/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal.context.java.formatters;

import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class GarbageCollectedObjectLabel implements IContextLabelFormatProvider {

	public String getDisplayStringFromElement(Object value, Object element, int mode) {
		return TraceUIMessages._221;
	}

	public Image getDisplayImageByElement(Object value, Object element, int mode) {
		return null;
	}

	public String getDisplayDescription() {
		return TraceUIMessages._221;
	}

	public String getDisplayToolTip() {
		return TraceUIMessages._221;
	}

	public String convertModelValueToDisplayString(String text) {
		return text;
	}

	public String convertDisplayStringToModelValue(String text) {
		return text;
	}

	public Double comparableDoubleValue(Object element) {
		return null;
	}

	private int[] supportedModes = null;
	
	public int[] getSupportModes() {
		
		if (supportedModes == null)
		{
			supportedModes = new int[1];
			supportedModes[0] = IContextLabelFormatProvider.MODE_COLUMN_HEADER;
		}
		
		return supportedModes;
	}
}
