/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.trace.views.internal.context.java.formatters;

import java.text.NumberFormat;
import java.util.List;

import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;

public class IntegerAttrLP extends AttrLPAdapter {
	
	boolean _formatIntegersWithCommas = false;
	NumberFormat _commaNumFormat = NumberFormat.getInstance();
	
	public IntegerAttrLP() {
		_formatIntegersWithCommas = false;
	}
	
	public IntegerAttrLP(boolean formatIntegersWithCommas) {
		_formatIntegersWithCommas = formatIntegersWithCommas;
	}
	
	public String getDisplayStringFromElement(Object value, Object element, int mode) {
		
		if (mode == IContextLabelFormatProvider.MODE_COLUMN_CONTENT)
		{
			if (value != null && value instanceof Integer) {
				// If the child class requests commas to be added as separators
				// to large number, then add as required.
				// (Note that in other locales this may be another symbol, as well)
				// (bug 317486)
				if(_formatIntegersWithCommas) {
					return _commaNumFormat.format((Integer)value);					
				}
				return String.valueOf(((Integer)value).intValue());
			} else if (value != null && value instanceof String) {
				return String.valueOf(value);
			} else if (value != null && value instanceof Boolean) {
				return ((Boolean)value).booleanValue()?"1":"0";
			}
		}
		return "";
	}	
	
	protected List internalSupportModes()
	{
		List modes = super.internalSupportModes();
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		return modes;
	}
}
