/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.views.internal.context.java.formatters;

import java.util.List;

import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class MethodInvocationAttrLP extends AttrLPAdapter {

	public String getDisplayStringFromElement(Object value, Object element, int mode) {
		if (mode == IContextLabelFormatProvider.MODE_COLUMN_HEADER)
			return TraceUIMessages._103;
		else if (mode == IContextLabelFormatProvider.MODE_COLUMN_CONTENT)
		{
			if (element instanceof TRCMethod)
			{
				TRCMethod method = (TRCMethod)element;
				StringBuffer buf = new StringBuffer();
				return buf.append(method.getName()).append(method.getSignature()).toString();
			}
			else if (value != null && value instanceof String)
				return (String)value;

		}
		return "";
	}		
	
	public Image getDisplayImageByElement(Object value, Object element, int mode) {
		return null;
	}
	
	protected List internalSupportModes()
	{
		List modes = super.internalSupportModes();
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_HEADER));
		
		return modes;
	}
}
