/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.views.internal.context.java.formatters;

import java.util.List;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class ObjectNameAttrLP extends AttrLPAdapter {

	public String getDisplayStringFromElement(Object value, Object element, int mode) {
		if (mode == IContextLabelFormatProvider.MODE_COLUMN_HEADER)
			return TraceUIMessages._54;
		else if (mode == IContextLabelFormatProvider.MODE_COLUMN_CONTENT)
		{
			if (element instanceof TRCObject)
			{
				TRCObject object = (TRCObject)element;
				TRCClass clas = PerftraceUtil.getClass(object);
				
				if(clas == object.getIsA())
				   return clas.getName() + "." + object.getId();
				   
				return clas.getName();		
			}
			else if (value != null && value instanceof String)
				return (String)value;

		}
		return "";
	}		
	
	public Image getDisplayImageByElement(Object value, Object element, int mode) {
		return null;
	}
	
	protected List internalSupportModes()
	{
		List modes = super.internalSupportModes();
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_HEADER));
		
		return modes;
	}	
}
