/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.views.internal.context.java.formatters;

import java.util.List;

import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class PackageNameAttrLP extends AttrLPAdapter {

	public String getDisplayStringFromElement(Object value, Object element, int mode) {
		if (mode == IContextLabelFormatProvider.MODE_VIEW_FILTER)
			return TraceMessages.ST_FPKN;
		else if (mode == IContextLabelFormatProvider.MODE_COLUMN_HEADER)
			return TraceUIMessages._21;
		else if (mode == IContextLabelFormatProvider.MODE_COLUMN_CONTENT)
		{
			if (value != null && value instanceof String)
			{
		        if (((String)value).length() == 0) {
		            return TraceUIMessages._87;
		        }
				return (String)value;
			}
		}
		return "";
	}		
	
	public Image getDisplayImageByElement(Object value, Object element, int mode) {
		return TracePluginImages.getImage(TracePluginImages.IMG_PACKAGE_COL);
	}
	
	protected List internalSupportModes()
	{
		List modes = super.internalSupportModes();
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_HEADER));
		modes.add(new Integer(IContextLabelFormatProvider.MODE_VIEW_FILTER));
		
		return modes;
	}	
}
