/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.trace.views.internal.context.java.formatters;

import java.util.List;

import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.osgi.util.NLS;

public class ReferenceDetailsToAttrLP extends AttrLPAdapter {
	
	public String getDisplayStringFromElement(Object value, Object element, int mode) {
		if (mode == IContextLabelFormatProvider.MODE_COLUMN_HEADER)
			return TraceUIMessages._123;
		else if (mode == IContextLabelFormatProvider.MODE_COLUMN_CONTENT)
		{
			if( value instanceof Integer && element instanceof TRCAggregatedObjectReference)
			{
				int size = ((Integer)value).intValue();
				TRCAggregatedObjectReference ref = ((TRCAggregatedObjectReference)element);
				
				 return NLS.bind(TraceUIMessages._121, new Object[] { String.valueOf(size)
											 , PerftraceUtil.getClass(ref.getTarget()).getName()});
			}
		
			return "";	
	   }
			
	   return "";
	}
	
	protected List internalSupportModes()
	{
		List modes = super.internalSupportModes();
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_HEADER));
		
		return modes;
	}
}
