/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ThreadClassNameAttrLP.java,v 1.1 2006/10/11 21:41:15 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal.context.java.formatters;

import java.util.List;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;

public class ThreadClassNameAttrLP extends AttrLPAdapter {

	public String getDisplayStringFromElement(Object value, Object element, int mode) {
		if (mode == IContextLabelFormatProvider.MODE_COLUMN_HEADER)
			return TraceUIMessages._19;
		else if (mode == IContextLabelFormatProvider.MODE_COLUMN_CONTENT)
		{
			if (element instanceof TRCThread) {
				TRCThread thread = (TRCThread)element;
				TRCClass cls = null;
				TRCPackage pkg = null;
				if (thread.getThreadObject() != null) {
					cls = thread.getThreadObject().getIsA();
					pkg = cls.getPackage();
				} else if (thread.getInitialInvocations().size() > 0) {
					cls = ((TRCMethodInvocation) thread.getInitialInvocations().get(0)).getMethod().getDefiningClass();
					pkg = cls.getPackage();
				}
				if (cls != null && pkg != null) {
					return "".equals(pkg.getName()) ? cls.getName() : (pkg.getName() + "." + cls.getName());
				}
			}
			else if (value instanceof String)
				return (String)value;
		}
		
		return "";
	}
	
	protected List internalSupportModes()
	{
		List modes = super.internalSupportModes();
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_HEADER));
		
		return modes;
	}	
}
