/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ThreadSleepingTimeAttrLP.java,v 1.1 2006/10/11 21:41:15 ewchan Exp $
 * 
 **********************************************************************/

package org.eclipse.hyades.trace.views.internal.context.java.formatters;

import java.util.List;

import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;

public class ThreadSleepingTimeAttrLP extends AttrLPAdapter {
	
	public String getDisplayStringFromElement(Object value, Object element, int mode) {
		if (mode == IContextLabelFormatProvider.MODE_COLUMN_CONTENT)
		{
			if (value != null && value instanceof Double)
				return TString.formatTimeValue(((Double)value).doubleValue());
		} else if (mode == IContextLabelFormatProvider.MODE_COLUMN_HEADER) {
			return TraceUIMessages._257;
		}
		return "";
	}	
	
	protected List internalSupportModes()
	{
		List modes = super.internalSupportModes();
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		modes.add(new Integer(IContextLabelFormatProvider.MODE_COLUMN_HEADER));
		
		return modes;
	}	
}
