/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Intel Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.views.internal.fragment;

import java.util.HashMap;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;

class ExpansionSelection extends TreeSelection implements
		IExpansionSelection {
	private HashMap expansionMap;
	private Expansion expansions[];
	static final Expansion[] EMPTY_EXPANSION_ARRAY = new Expansion[0];
	static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];
	public static final ExpansionSelection EMPTY = new ExpansionSelection();
	
	public ExpansionSelection(){
		this((Expansion[])null);
	}

	public ExpansionSelection(Expansion exp){
		this(new Expansion[]{exp});
	}

	public ExpansionSelection(Expansion[] exps){
		super(expsToTreePaths(exps));
		if(exps != null && exps.length != 0){
			expansions = (Expansion[])exps.clone();
			expansionMap = new HashMap();
			for(int i = 0; i < exps.length; i++){
				Expansion exp = exps[i];
				Assert.isTrue(exp.getData() != null);
				expansionMap.put(exp.getData(), exp);
			}
		}
	}
	
	private static TreePath[] expsToTreePaths(Expansion[] exps){
		if(exps == null || exps.length == 0)
			return EMPTY_TREEPATH_ARRAY;
		
		TreePath[] paths = new TreePath[exps.length];
		for(int i = 0; i < exps.length; i++){
			paths[i] = exps[i].toTreePath();
		}
		return paths;
	}

	public Expansion[] getExpansions() {
		return expansions != null ? (Expansion[])expansions.clone() : EMPTY_EXPANSION_ARRAY;
	}

	public Expansion[] getExpansionsFor(Object element) {
		Object exp = expansionMap.get(element);
		if(exp == null)
			return EMPTY_EXPANSION_ARRAY;
		if(exp instanceof Expansion)
			return new Expansion[]{(Expansion)exp};
		Assert.isTrue(false);
		return null;
	}

	public boolean equals(Object obj) {
		if (!(obj instanceof ExpansionSelection)) {
			// Fall back to super implementation, see bug 135837.
			return super.equals(obj);
		}
		ExpansionSelection other = (ExpansionSelection) obj;
		Expansion[] exps = getExpansions();
		Expansion[] otherExps = other.getExpansions();
		if(exps.length != otherExps.length)
			return false;
		
		for(int i = 0; i < exps.length; i++){
			if(!exps[i].equals(otherExps[i]))
				return false;
		}
		
		return true;
	}

	public int hashCode() {
		int code = getClass().hashCode();
		if (expansions != null) {
			for (int i = 0; i < expansions.length; i++) {
				code = code * 17 + expansions[i].hashCode();
			}
		}
		return code;
	}
}
