/*******************************************************************************
 * Copyright (c) 2008 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Intel Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.views.internal.fragment;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.Assert;

public final class RootExpansion extends Expansion implements Cloneable {
	private Map objectToExpansionMap = new HashMap();
	
	public RootExpansion(Object element, int size) {
		super(element, size);
		IAmRoot();
		linkExpansion(this);
	}
	
	
	private RootExpansion(RootExpansion base) {
		super(null, base);
	}


	void linkExpansion(Expansion exp){
		Object old = objectToExpansionMap.put(exp.getData(), exp);
		Assert.isTrue(old == null);
	}

	void unlinkExpansion(Expansion exp){
		Expansion rm = (Expansion)objectToExpansionMap.remove(exp.getData());
		Assert.isTrue(rm.equals(exp));
	}
	
	public Expansion getExpansion(Object element){
		return (Expansion)objectToExpansionMap.get(element);
	}

	public boolean equals(Object obj) {
		return this == obj;
	}

	public int hashCode() {
		return System.identityHashCode(this);
	}

	public Object clone() {
		return new RootExpansion(this);
	}
}
