/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.util.internal.MethodCallDetails;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractNumberColumnLabel extends ColumnLabelAdapter {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {

		String attributeId = getContextAttribute(element, info);
		if (attributeId == null)
			return "";

		EObject eObj = ContextUpdaterHelper.getEObject(element);
		IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), attributeId, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		
		if(!info.isDeltaColumn)
		{																				
			if(info.showPercentage)
				return TString.formatAsPercentage(getValue(element, info).doubleValue()/info.max);
			else
				return formatter.getDisplayStringFromElement(getValue(element, info), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);					  
		}
		else
		{
			if (element instanceof TRCPackage
					|| element instanceof TRCClass
					|| element instanceof TRCMethod
					|| element instanceof MethodCallDetails)					  
				return formatter.getDisplayStringFromElement(getDelta(element, info), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
			else
				return "";
		}
	}
	
	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		if(!info.isDeltaColumn)
		{
			Number delta = getDelta(element, info);
			
			double d = delta!=null?delta.doubleValue():0;
			
			if (d < 0) 
				return TracePluginImages.getImage(TracePluginImages.IMG_DELTADOWN);
			if(d > 0)
				return TracePluginImages.getImage(TracePluginImages.IMG_DELTAUP);
			else
			{
				String attributeId = getContextAttribute(element, info);
				if (attributeId == null)
					return null;
				
				EObject eObj = ContextUpdaterHelper.getEObject(element);
				
				IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), attributeId, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				return createImage(formatter.getDisplayImageByElement(getValue(element, info), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
			}
		}
			
		return null;
	}		

	protected abstract Number getValue(Object element, ColumnDisplayInfo info);
	protected abstract Number getDelta(Object element, ColumnDisplayInfo info);
	protected abstract String getContextAttribute(Object element, ColumnDisplayInfo info);
	
	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info)
	{
		if (!info.isDeltaColumn) {
			Number num = getValue(element, info);
			// For a null Value, return the comparison size of 0.
			if(num == null)
				return new Double(0);
			else
				return new Double(num.doubleValue());
		}
		else {
			Number num = getDelta(element, info);
			// For a null Delta, return the comparison size of 0.
			if(num == null)
				return new Double(0);
			else
				return new Double(num.doubleValue());
		}
	}
}

