/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;

public class ActiveSizeColumnLabel extends AbstractNumberColumnLabel {

	/**
	 * Returns the active size for the requested element.
	 */
	protected Number getValue(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
		{
			TRCPackageImpl.TRCPackageSnapshot ps = (TRCPackageImpl.TRCPackageSnapshot)((TRCPackage) element).retrieveSnapshot();		
			return new Integer(ps.getTotalSize() - ps.getCollectedSize());
		}
		if (element instanceof TRCClass)
		{
			TRCClassImpl.TRCClassSnapshot cs = (TRCClassImpl.TRCClassSnapshot)((TRCClass) element).retrieveSnapshot();		
			return new Integer(cs.getTotalSize() - cs.getCollectedSize());			
		}
		if(element instanceof TRCFullTraceObject)
		{
			int size = 0;
			if(((TRCFullTraceObject)element).getCollectTime() != 0)
				size = 0;
			else
				size = ((TRCFullTraceObject)element).getSize();
		  
			return new Integer(size);
		}
		if(element instanceof TRCObject)
		{
			return new Integer(((TRCObject)element).getSize());
		}

		
		return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		
		if (element instanceof TRCPackage)
		{
			TRCPackageSnapshot delta = packageSnapshot();		
			TRCPackage p = (TRCPackage) element;
			
			p.computeDelta(delta,TracePackage.TRC_PACKAGE__TOTAL_SIZE);
			p.computeDelta(delta,TracePackage.TRC_PACKAGE__COLLECTED_SIZE);
			
			return new Integer(delta.getTotalSize() - delta.getCollectedSize());
		}
		if (element instanceof TRCClass)
		{
			TRCClassSnapshot delta = classSnapshot();					
			TRCClass c = (TRCClass) element;
			
			c.computeDelta(delta,TracePackage.TRC_CLASS__TOTAL_SIZE);
			c.computeDelta(delta,TracePackage.TRC_CLASS__COLLECTED_SIZE);
			
			return new Integer(delta.getTotalSize() - delta.getCollectedSize());	
		}
		
		return null;
	}

	/**
	 * Describe for which attribute the information is being requested.
	 */
	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);
		
		if (eObj instanceof TRCPackage)
			return IContextAttributes.PACKAGE_ACTIVE_SIZE;
		else if (eObj instanceof TRCClass)
			return IContextAttributes.CLASS_ACTIVE_SIZE;
		else if (eObj instanceof TRCObject)
			return IContextAttributes.OBJECT_ACTIVE_SIZE;
		else
			return null;
	}
}
