/**********************************************************************
 * Copyright (c) 2006, 2010 Intel Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AggregatedCallsColumnLabel.java,v 1.3 2010/06/25 21:05:04 jwest Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import java.text.NumberFormat;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.trace.views.util.internal.AggregatedInvocation;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.swt.graphics.Image;

public class AggregatedCallsColumnLabel extends CallsColumnLabel {	
	
	NumberFormat nf = NumberFormat.getInstance();
	
	// Add comma separators for large numbers (bug 317486)
	private String formatCallsWithCommaSep(int x) {
		return nf.format(x);
	}
	
	protected Number getValue(Object element, ColumnDisplayInfo info) {
        if (element instanceof AggregatedInvocation)
            return new Integer(((AggregatedInvocation)element).getAllInvocations().size());
		return null;
	}	
	
	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		Number value = getValue(element, info);
		return value != null ? formatCallsWithCommaSep(value.intValue()) : "";
	}
	
	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		return null;
	}

	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
        EObject eObj = ContextUpdaterHelper.getEObject(element);
        
        if (eObj instanceof TRCMethod || eObj instanceof TRCMethodInvocation)
            return IContextAttributes.METHOD_CALLS;
        return super.getContextAttribute(element, info);
	}	
}
