/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AggregatedClassNameColumnLabel.java,v 1.1 2006/09/21 19:19:28 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import java.util.Iterator;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;

public class AggregatedClassNameColumnLabel extends ClassNameColumnLabel {
	protected TRCClass getTRCClass(Object element)
	{		
		if (element instanceof TRCMethodInvocation)
			return ((TRCMethodInvocation)element).getMethod().getDefiningClass();
		if (element instanceof TRCThread) {
			TRCThread thread = (TRCThread)element;			
			for (Iterator i = thread.getInitialInvocations().iterator(); i.hasNext();) {
				TRCMethodInvocation inv = (TRCMethodInvocation)i.next();
				if ("main".equals(inv.getMethod().getName()) || "run".equals(inv.getMethod().getName())) {
					return inv.getMethod().getDefiningClass();
				}
			}
		}
		return super.getTRCClass(element);
	}
}
