/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AggregatedCumulativeTimeColumnLabel.java,v 1.2 2006/10/11 22:11:11 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.util.internal.AggregatedInvocation;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.swt.graphics.Image;

public class AggregatedCumulativeTimeColumnLabel extends AbstractNumberColumnLabel {
	
	protected Number getValue(Object element, ColumnDisplayInfo info) {
		if (element instanceof AggregatedInvocation) {
			return new Double(((AggregatedInvocation)element).getSumTime());
		}
		if (element instanceof AggregatedInvocation.Item) {
			return new Double(((AggregatedInvocation.Item)element).getSumTime());
		}
		if (element instanceof TRCThread) {
			return new Double(getThreadTime((TRCThread)element));
		}
		return null;
	}
	
	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		Number value = getValue(element, info);
		return value != null ? TString.formatTimeValue(value.doubleValue()) : "";
	}
	
	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		return null;
	}

	private double getThreadTime(TRCThread thread) {
		double startTime = thread.getStartTime();
		double stopTime = thread.getStopTime();
		if (stopTime < startTime) {
			stopTime = thread.getProcess().getLastEventTime();
		}
		return Math.max(stopTime - startTime, 0);
	}

	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
		if (element instanceof AggregatedInvocation)
		{
			return IContextAttributes.METHOD_CUMULATIVE_TIME;
		} else if (element instanceof TRCThread) {
			return IContextAttributes.METHOD_CUMULATIVE_TIME;
		}
		return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		return null;
	}	
}
