/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl.TRCMethodSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class AvgBaseTimeColumnLabel extends ColumnLabelAdapter {
	
	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);
		IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), getContextAttribute(eObj, info), IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		
		if(info.showPercentage)
			return TString.formatAsPercentage(comparableDoubleValue(element, null).doubleValue() / info.max);
		else
			return formatter.getDisplayStringFromElement(comparableDoubleValue(element, null), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
	}
	
	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);
		IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), getContextAttribute(eObj, info), IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		
		return createImage(formatter.getDisplayImageByElement(comparableDoubleValue(element, null), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
	}	

	protected int getCalls(Object element) {
		if (element instanceof TRCPackage)
			return ((TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getCalls();
		if (element instanceof TRCClass)
			return ((TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getCalls();
		if (element instanceof TRCMethod)
			return ((TRCMethodSnapshot)((TRCMethod)element).retrieveSnapshot()).getCalls();		
		
		return 0;
	}
	
	protected double getBaseTime(Object element)
	{
		if (element instanceof TRCPackage)
			return ((TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getBaseTime();
		if (element instanceof TRCClass)
			return ((TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getBaseTime();
		if (element instanceof TRCMethod)
			return ((TRCMethodSnapshot)((TRCMethod)element).retrieveSnapshot()).getBaseTime();
		
		return 0;
	}

	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info)
	{
		int calls = getCalls(element);
		if(calls == 0)
			calls = 1;
		
		return new Double(getBaseTime(element) / calls);
	}
	
	protected String getContextAttribute(EObject element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
			return IContextAttributes.PACKAGE_AVG_BASE_TIME;
		else if (element instanceof TRCClass)
			return IContextAttributes.CLASS_AVG_BASE_TIME;
		else if (element instanceof TRCMethod)
			return IContextAttributes.METHOD_AVG_BASE_TIME;
		else
			return null;
	}		
}
