/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl.TRCMethodSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;

public class BaseTimeColumnLabel extends AbstractNumberColumnLabel {

	protected Number getValue(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
			return new Double(((TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getBaseTime());
		if (element instanceof TRCClass)
			return new Double(((TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getBaseTime());
		if (element instanceof TRCMethod)
			return new Double(((TRCMethodSnapshot)((TRCMethod)element).retrieveSnapshot()).getBaseTime());
		if (element instanceof TRCFullTraceObject)
			return new Double(((TRCFullTraceObject)element).getBaseTime());		

		return null;
	}
	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
		{
			TRCPackageSnapshot delta = packageSnapshot();
			((TRCPackage)element).computeDelta(delta,TracePackage.TRC_PACKAGE__BASE_TIME);
			return new Double(delta.getBaseTime());
		}
		if (element instanceof TRCClass)
		{
			TRCClassSnapshot delta = classSnapshot();			
			((TRCClass)element).computeDelta(delta,TracePackage.TRC_CLASS__BASE_TIME);
			return new Double(delta.getBaseTime());
		}
		if (element instanceof TRCMethod)
		{
			TRCMethodSnapshot delta = methodSnapshot();				
			((TRCMethod)element).computeDelta(delta,TracePackage.TRC_METHOD__BASE_TIME);
			return new Double(delta.getBaseTime());
		}		
		
		return null;
	}
	
	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);		
		
		if (eObj instanceof TRCPackage)
			return IContextAttributes.PACKAGE_BASE_TIME;
		else if (eObj instanceof TRCClass)
			return IContextAttributes.CLASS_BASE_TIME;
		else if (eObj instanceof TRCMethod)
			return IContextAttributes.METHOD_BASE_TIME;
		else if (eObj instanceof TRCObject)
			return IContextAttributes.OBJECT_BASE_TIME;
		else
			return null;
	}	
}
