/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl.TRCMethodSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;

public class CPUTimeColumnLabel extends AbstractNumberColumnLabel {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		if(element == null) 
			return "";	
		
		if (element instanceof TRCFullTraceObject && info.isDeltaColumn)
			return "";
		
		if (element instanceof TRCFullMethodInvocation && info.isDeltaColumn)
			return "";		

		return super.getDisplayString(element, info);
	}	
	
	protected Number getValue(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
			return new Double(((TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getTotalCpuTime());
		if (element instanceof TRCClass)
			return new Double(((TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getTotalCpuTime());
		if (element instanceof TRCMethod)
			return new Double(((TRCMethodSnapshot)((TRCMethod)element).retrieveSnapshot()).getTotalCpuTime());	
		if(element instanceof TRCFullTraceObject)
			return new Double(getTRCFullTraceCPUtime(((TRCFullTraceObject)element)));
		if(element instanceof TRCFullMethodInvocation)
			return new Double(((TRCFullMethodInvocation)element).getCpuTime());

		return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
		{
			TRCPackageSnapshot delta = packageSnapshot();
			((TRCPackage)element).computeDelta(delta,TracePackage.TRC_PACKAGE__TOTAL_CPU_TIME);
			return new Double(delta.getTotalCpuTime());
		}
		if (element instanceof TRCClass)
		{
			TRCClassSnapshot delta = classSnapshot();			
			((TRCClass)element).computeDelta(delta,TracePackage.TRC_CLASS__TOTAL_CPU_TIME);
			return new Double(delta.getTotalCpuTime());
		}
		if (element instanceof TRCMethod)
		{
			TRCMethodSnapshot delta = methodSnapshot();				
			((TRCMethod)element).computeDelta(delta,TracePackage.TRC_METHOD__TOTAL_CPU_TIME);
			return new Double(delta.getTotalCpuTime());
		}		
		
		return null;
	}
	
	private double getTRCFullTraceCPUtime(TRCFullTraceObject fullTraceObject)
	{
		double totalCPUtime = 0.0000000;
		 for (Iterator methodInvocations = fullTraceObject.getInvocations().iterator(); methodInvocations.hasNext();) {
		 		EObject methodInvo = (EObject) methodInvocations.next();
		 			if (methodInvo instanceof TRCFullMethodInvocation)
		 				totalCPUtime += ((TRCFullMethodInvocation)methodInvo).getCpuTime();
		 			else if (methodInvo instanceof TRCAggregatedMethodInvocation)
		 				totalCPUtime += ((TRCAggregatedMethodInvocation)methodInvo).getTotalCpuTime();
		        }
		 return totalCPUtime;
		  
	}
	
	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);		
		
		if (eObj instanceof TRCPackage)
			return IContextAttributes.PACKAGE_CPU_TIME;
		else if (eObj instanceof TRCClass)
			return IContextAttributes.CLASS_CPU_TIME;
		else if (eObj instanceof TRCMethod)
			return IContextAttributes.METHOD_CPU_TIME;
		else if (eObj instanceof TRCObject)
			return IContextAttributes.OBJECT_CPU_TIME;
		else if (eObj instanceof TRCFullMethodInvocation)
			return IContextAttributes.METHOD_CPU_TIME;
		else
			return null;
	}	
}
