/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl.TRCMethodSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.MethodCallDetails;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;

public class CallsColumnLabel extends AbstractNumberColumnLabel {

	
	public String getDisplayString(Object element, ColumnDisplayInfo info)
	{
		if (info.isCallsMeaningfull)
			return super.getDisplayString(element, info);
		else
			return "";
	}
	
	protected Number getValue(Object element, ColumnDisplayInfo info) {
		if (element == null)
			return null;
		if (element instanceof TRCPackage)
			return new Integer(((TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getCalls());
		if (element instanceof TRCClass)
			return new Integer(((TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getCalls());
		if (element instanceof TRCMethod)
			return new Integer(((TRCMethodSnapshot)((TRCMethod)element).retrieveSnapshot()).getCalls());
		if (element instanceof MethodCallDetails)
			return new Integer(((MethodCallDetails)element).getCalls());		
		if(element instanceof TRCFullTraceObject)
			return new Integer(((TRCFullTraceObject)element).getCalls());
		if(element instanceof Coverage)
			return new Integer(((Coverage)element).getCalls());		
		

		return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		if (element == null)
			return null;
		
		if (element instanceof TRCPackage)
		{
			TRCPackageSnapshot delta = packageSnapshot();			
			((TRCPackage)element).computeDelta(delta,TracePackage.TRC_PACKAGE__CALLS);
			return new Integer(delta.getCalls());
		}
		if (element instanceof TRCClass)
		{
			TRCClassSnapshot delta = classSnapshot();				
			((TRCClass)element).computeDelta((TRCClassSnapshot)delta,TracePackage.TRC_CLASS__CALLS);
			return new Integer(((TRCClassSnapshot)delta).getCalls());
		}
		if (element instanceof TRCMethod)
		{
			TRCMethodSnapshot delta = methodSnapshot();					
			((TRCMethod)element).computeDelta(delta, TracePackage.TRC_METHOD__CALLS);
			return new Integer(delta.getCalls());
		}
        if(element instanceof MethodCallDetails)
        {
           MethodCallDetails methodDetails = (MethodCallDetails)element;
           return getDelta(methodDetails.getMethod(), info);
        }
		
		return null;
	}
	
	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {

		if (element instanceof Coverage)
			return IContextAttributes.COVERAGE_CALLS;
		
		EObject eObj = ContextUpdaterHelper.getEObject(element);		
		
		if (eObj instanceof TRCPackage)
			return IContextAttributes.PACKAGE_CALLS;
		else if (eObj instanceof TRCClass)
			return IContextAttributes.CLASS_CALLS;
		else if (eObj instanceof TRCMethod)
			return IContextAttributes.METHOD_CALLS;
		else if(eObj instanceof TRCFullTraceObject)
			return IContextAttributes.OBJECT_CALLS;
		else
			return null;
	}	
}
