/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PackageNameColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class ClassNameColumnLabel extends ColumnLabelAdapter {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		TRCClass clas = getTRCClass(element);
	
		if (clas != null)
		{
			String displayString = getDisplyStringFromMap(clas);
			if (displayString==null)
			{
				EObject eObj = ContextUpdaterHelper.getEObject(element);
				IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.CLASS_NAME, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				displayString = formatter.getDisplayStringFromElement(clas.getName(), clas, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				displayStringMap.put(clas,displayString);
			}
			
			return displayString;
		}
		
		return "";
	}

	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		TRCClass clas = getTRCClass(element);
		
		if (clas != null)
		{
			EObject eObj = ContextUpdaterHelper.getEObject(element);
			IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.CLASS_NAME, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
			return createImage(formatter.getDisplayImageByElement(clas.getName(), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		}
		
		return null;
	}
	
	protected TRCClass getTRCClass(Object element)
	{
		if (element instanceof TRCClass)
			return (TRCClass)element;
		if (element instanceof TRCMethod)
			return ((TRCMethod)element).getDefiningClass();
		if (element instanceof Coverage)
		{
			EObject obj = ((Coverage)element).getTraceObj();
			if(obj instanceof TRCClass)
				return (TRCClass)obj;
			if(obj instanceof TRCMethod)
				return ((TRCMethod)obj).getDefiningClass();
		}

		return null;
	}
	
	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		return null;
	}
}
