/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;

public class CollectedInstancesColumnLabel extends AbstractNumberColumnLabel {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		if (element == null)
			return "";
		
		if(element instanceof TRCFullTraceObject)
		{
			if (info.isDeltaColumn)
				return "";					
			
			EObject eObj = ContextUpdaterHelper.getEObject(element);

			IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(ContextUpdaterHelper.getContext(eObj), IContextAttributes.OBJECT_COLLECTED, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
			
			return formatter.getDisplayStringFromElement(new Boolean(((TRCFullTraceObject)element).getCollectTime() != 0), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		}

		return super.getDisplayString(element, info);
	}

	protected Number getValue(Object element, ColumnDisplayInfo info) {
		if (element == null)
			return null;
		
		if (element instanceof TRCPackage)
		{
			TRCPackageImpl.TRCPackageSnapshot ps = (TRCPackageImpl.TRCPackageSnapshot)((TRCPackage) element).retrieveSnapshot();
			
//		  	int inst = ps.getTotalInstances();
//		  	if(inst == 0) inst = 1;
//		  	updateFormat(IUpdateAttributes.TOTAL_INSTANCE, new Double(inst));
			
			return new Integer(ps.getCollectedInstances());
		}
		if (element instanceof TRCClass)
		{
			TRCClassImpl.TRCClassSnapshot cs = (TRCClassImpl.TRCClassSnapshot)((TRCClass) element).retrieveSnapshot();
			
//		  	int inst = cs.getTotalInstances();
//		  	if(inst == 0) inst = 1;
//		  	updateFormat(IUpdateAttributes.TOTAL_INSTANCE, new Double(inst));
			
			return new Integer(cs.getCollectedInstances());
		}
		
		return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
		{
			TRCPackageSnapshot delta = packageSnapshot();
			((TRCPackage)element).computeDelta(delta,TracePackage.TRC_PACKAGE__COLLECTED_INSTANCES);
			return new Integer(delta.getCollectedInstances());
		}
		if (element instanceof TRCClass)
		{
			TRCClassSnapshot delta = classSnapshot();			
			((TRCClass)element).computeDelta(delta,TracePackage.TRC_CLASS__COLLECTED_INSTANCES);
			return new Integer(delta.getCollectedInstances());
		}
		
		return null;
	}
	
	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);		
		
		if (eObj instanceof TRCPackage)
			return IContextAttributes.PACKAGE_COLLECTED_INST;
		else if (eObj instanceof TRCClass)
			return IContextAttributes.CLASS_COLLECTED_INST;
		else if (eObj instanceof TRCClass)
			return IContextAttributes.OBJECT_COLLECTED;
		else
			return null;
	}		
}
