/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import java.util.Hashtable;
import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl.TRCMethodSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.swt.graphics.Image;

public abstract class ColumnLabelAdapter {
	
	private TRCPackageSnapshot ps;
	private TRCClassSnapshot cs;
	private TRCMethodSnapshot ms;
	
	protected Map contextMap;
	protected Map displayStringMap;
	
	public void initialize(TRCPackageSnapshot _ps, TRCClassSnapshot _cs, TRCMethodSnapshot _ms)
	{
		ps = _ps;
		cs = _cs;
		ms = _ms;
	}
	
	protected TRCPackageSnapshot packageSnapshot()
	{
		return ps;
	}
	
	protected TRCClassSnapshot classSnapshot()
	{
		return cs;
	}
	
	protected TRCMethodSnapshot methodSnapshot()
	{
		return ms;
	}	

	private ColumnDisplayInfo info = null;
	
	public ColumnDisplayInfo getColumnDisplayInfo()
	{
		if (info == null)
			info = new ColumnDisplayInfo();
		
		return info;
	}
	
	public abstract String getDisplayString(Object element, ColumnDisplayInfo info);
	public abstract Image getDisplayImage(Object element, ColumnDisplayInfo info);
	public abstract Double comparableDoubleValue(Object element, ColumnDisplayInfo info);
	
	protected Image createImage(Image img)
	{
		return img;
	}
	
	public void resetMap() 
	{
		if (contextMap!=null) contextMap.clear();
		if (displayStringMap!=null) displayStringMap.clear();
	}
	
	protected String getContext(EObject eObj) {
		if (contextMap==null) 
		{
			contextMap=new Hashtable();
		}
		
		String context;
		if (eObj!=null)
		{
			context = (String)contextMap.get(eObj);
	
			if (context==null)
			{
				context = ContextUpdaterHelper.getContext(eObj);
				contextMap.put(eObj,context);
			}
		}
		else {
			context = ContextUpdaterHelper.getContext(eObj);
		}
		
		return context;
		
		
	}
	
	protected String getDisplyStringFromMap(EObject element) {
		if (displayStringMap==null) displayStringMap=new Hashtable();
		return (String)displayStringMap.get(element);
	}

}
