/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ColumnLabelComparator.java,v 1.1 2005/08/18 14:00:58 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;


public class ColumnLabelComparator {

	public static int compare(Object obj1, Object obj2, ColumnLabelAdapter col, ColumnDisplayInfo info)
	{
		Double d1 = col.comparableDoubleValue(obj1, info);
		Double d2 = col.comparableDoubleValue(obj2, info);
		
		if (d1 != null && d2 != null)
		{
			double d = d1.doubleValue() - d2.doubleValue();
			
			if (d > 0)
				return 1;
			else if (d < 0)
				return -1;
			else
				return 0;
		}
		else if (d1 != null && d2 == null)
			return -1;
		else if (d1 == null && d2 != null)
			return 1;
		else
		{
			String text1 = col.getDisplayString(obj1, info);
			String text2 = col.getDisplayString(obj2, info);
			
			return text1.compareToIgnoreCase(text2);
		}
	}
}
