/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
  * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCLanguageElement;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl.TRCMethodSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.internal.FilteringUtil;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.MethodCallDetails;
import org.eclipse.hyades.trace.views.util.internal.ThreadDetails;
import org.eclipse.hyades.ui.provisional.context.ContextManager;

public class ContextUpdaterHelper {

	public static ColumnDisplayInfo updatePackageName(ColumnLabelAdapter col, EObject mofObject)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();
		info.mofObject = mofObject;
		
		return info;
	}
	
	public static ColumnDisplayInfo updateActiveSize(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, double totalActiveSize)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.max = totalActiveSize;
		
		return info;
	}
	
	public static ColumnDisplayInfo updateAvgBaseTime(ColumnLabelAdapter col, boolean showPercent, double maxTime)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();
		
		info.showPercentage = showPercent;
		info.max = maxTime;
		
		return info;
	}
	
	public static ColumnDisplayInfo updateBaseTime(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, double maxTime)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.max = maxTime;
		
		return info;
	}

	public static ColumnDisplayInfo updateCalls(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, boolean isCallsMeaningfull, double totalCalls)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.isCallsMeaningfull = isCallsMeaningfull;
		info.max = totalCalls;
		
		return info;
	}	

	public static ColumnDisplayInfo updateCollectedInst(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, double totalInst)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.max = totalInst;
		
		return info;
	}
	
	
	public static ColumnDisplayInfo updateCPUTime(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, double totalCPUTime)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.max = totalCPUTime;
		
		return info;
	}
	
	public static ColumnDisplayInfo updateCumulTime(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, int drawMode, double maxTime)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.drawMode = drawMode;
		info.max = maxTime;
		
		return info;
	}	
	
	public static ColumnDisplayInfo updateInhBaseTime(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, double maxTime)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.max = maxTime;
		
		return info;
	}
	
	public static ColumnDisplayInfo updateInhCalls(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, double totalCalls)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.max = totalCalls;
		
		return info;
	}	
	
	public static ColumnDisplayInfo updateInhCumulTime(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, double maxTime)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.max = maxTime;
		
		return info;
	}	

	public static ColumnDisplayInfo updateLiveInstances(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, double activeInstances)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.max = activeInstances;
		
		return info;
	}	

	public static ColumnDisplayInfo updateRefCol(ColumnLabelAdapter col, boolean showReferTo)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		
		info.showReferTo = showReferTo;
		
		return info;		
	}
	
	public static ColumnDisplayInfo updateTotalInstances(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, double totalInstances)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.max = totalInstances;
		
		return info;
	}	

	public static ColumnDisplayInfo updateTotalSize(ColumnLabelAdapter col, boolean isDeltaColumn, boolean showPercent, double totalSize)
	{
		ColumnDisplayInfo info = col.getColumnDisplayInfo();		
		
		info.isDeltaColumn = isDeltaColumn;
		info.showPercentage = showPercent;
		info.max = totalSize;
		
		return info;
	}	
	
	public static void addSnapshots(ColumnLabelAdapter col, TRCPackageSnapshot ps, TRCClassSnapshot cs, TRCMethodSnapshot ms)
	{
		col.initialize(ps, cs, ms);
	}	
	
	public static String[] getContexts(EObject eObject)
	{
		String languages[] = null;
		
		if (eObject instanceof TRCLanguageElement)
		{
			TRCSourceInfo sourceInfo = ((TRCLanguageElement)eObject).getSourceInfo();
			if (sourceInfo != null && sourceInfo.getLanguage()!=null)
			{
				languages = new String[1];
				languages[0] = sourceInfo.getLanguage();
			}
			else
				languages = getContexts(eObject.eContainer());
		}
		else if (eObject instanceof TRCObject)
			languages = getContexts( PerftraceUtil.getClass((TRCObject)eObject) );
		else if (eObject instanceof TRCMethodInvocation)
			languages = getContexts( ((TRCMethodInvocation)eObject).getMethod() );
		else if (eObject instanceof TRCThread)
			languages = getContexts( ((TRCThread)eObject).getThreadObject() );
		else 
		{
			List processList = FilteringUtil.getProcessList(eObject);
			
			if (processList.size() > 0) {
				List la = new ArrayList();
	
				TRCProcess process;
				for (int i = 0; i < processList.size(); i++)
				{
					process = (TRCProcess)processList.get(i);
					if (process!=null)
					{
						Iterator e = process.getLanguages().iterator();
						while (e.hasNext()) {
							String lang = (String)e.next();
							if (!la.contains(lang)) {
								la.add(lang);
							}
						}
					}
					else
					{
						String lang = ContextManager.getDefautContext();
						if (!la.contains(lang)) 
							la.add(lang);
					}
				}
				
				String[] langArray = new String[la.size()];
				la.toArray(langArray);
				languages = langArray;
			}
		}
		
		if (languages != null && languages.length > 0)
			return languages;
		else
		{
			languages = new String[1];
			languages[0] = ContextManager.getDefautContext();
			return languages;
		}
	}
	
	public static String getContext(EObject eObject)
	{
		String[] contexts = getContexts(eObject);
		
		if (contexts.length > 0)
			return contexts[0];
		else
			return ContextManager.getDefautContext();
	}
	
	public static EObject getEObject(Object element)
	{
		if (element instanceof MethodCallDetails)
			return ((MethodCallDetails)element).getMethod();		
		else if(element instanceof Coverage)
			return ((Coverage)element).getTraceObj();
		else if(element instanceof ThreadDetails)
			return ((ThreadDetails)element).getThread();
		else
			return (EObject)element;
	}
	
	private static String currentFocusContextLanguage;
	
	public static void setCurrentFocusContextLanguage(String context)
	{
		currentFocusContextLanguage = context;
	}

	public static String getCurrentFocusContextLanguage()
	{
		return currentFocusContextLanguage;
	}
	
	public static String getCurrentContext(String[] contexts, IContextViewer viewer)
	{
		String selectedContext = viewer.getSelectedContext();

		for (int i = 0; i < contexts.length; i++)
		{
			if (contexts[i].equals(selectedContext))
				return selectedContext;
		}

		if (contexts.length > 0)
			return contexts[0];
		else
			return ContextManager.getDefautContext();
	}
}
