/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl.TRCMethodSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.hyades.trace.views.adapter.internal.TraceConstants;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;

public class CumulativeTimeColumnLabel extends AbstractNumberColumnLabel {
	
	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		if(element == null) 
			return "";	
		
		if (element instanceof TRCFullTraceObject && info.isDeltaColumn)
			return "";
		
		if (element instanceof TRCFullMethodInvocation && info.isDeltaColumn)
			return "";		

		return super.getDisplayString(element, info);
	}	
	

	protected Number getValue(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
			return new Double(((TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getCumulativeTime());
		if (element instanceof TRCClass)
			return new Double(((TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getCumulativeTime());		
		if (element instanceof TRCMethod)
			return new Double(((TRCMethodSnapshot)((TRCMethod)element).retrieveSnapshot()).getCumulativeTime());
		if(element instanceof TRCFullTraceObject)
			return new Double(((TRCFullTraceObject)element).getCumulativeTime());	
		if (element instanceof TRCFullMethodInvocation)
		{
			TRCFullMethodInvocation inv = (TRCFullMethodInvocation)element;
			double start = inv.getEntryTime();
			double end = inv.getExitTime();
			double overhead = inv.getOverhead();
			
			if(end == 0)
				end = inv.getProcess().getLastEventTime();
			
			if (info.drawMode == TraceConstants.COMPENSATED_TIME)
				return new Double(end-start-overhead);
			else
				return new Double(end-start);
		}

		return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
		{
			TRCPackageSnapshot delta = packageSnapshot();
			((TRCPackage)element).computeDelta(delta,TracePackage.TRC_PACKAGE__CUMULATIVE_TIME);
			return new Double(delta.getCumulativeTime());
		}
		if (element instanceof TRCClass)
		{
			TRCClassSnapshot delta = classSnapshot();			
			((TRCClass)element).computeDelta(delta,TracePackage.TRC_CLASS__CUMULATIVE_TIME);
			return new Double(delta.getCumulativeTime());
		}
		if (element instanceof TRCMethod)
		{
			TRCMethodSnapshot delta = methodSnapshot();				
			((TRCMethod)element).computeDelta(delta,TracePackage.TRC_METHOD__CUMULATIVE_TIME);
			return new Double(delta.getCumulativeTime());
		}		
		
		return null;
	}

	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);		
		
		if (eObj instanceof TRCPackage)
			return IContextAttributes.PACKAGE_BASE_TIME;
		else if (eObj instanceof TRCClass)
			return IContextAttributes.CLASS_BASE_TIME;
		else if (eObj instanceof TRCMethod)
			return IContextAttributes.METHOD_BASE_TIME;
		else if (eObj instanceof TRCObject)
			return IContextAttributes.OBJECT_BASE_TIME;
		else if (eObj instanceof TRCFullMethodInvocation)
		{
			if (info.drawMode == TraceConstants.COMPENSATED_TIME)
				return IContextAttributes.METHOD_CUMULATIVE_TIME;
			else
				return IContextAttributes.METHOD_RAW_CUMULATIVE_TIME;
		}
		else
			return null;
	}	
}
