/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.swt.graphics.Image;

public class FullyQualMethodInvLabel extends ColumnLabelAdapter {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		  if(element instanceof TRCFullMethodInvocation)
			  return getDisplayString(((TRCFullMethodInvocation)element).getMethod(), info);
		  else if(element instanceof TRCMethod)
		  {
			  TRCMethod method = (TRCMethod) element;
						   
			  String pgkname = new PackageNameColumnLabel().getDisplayString(method.getDefiningClass().getPackage(), null);//.getName();
			  String implname = new ClassNameColumnLabel().getDisplayString(method.getDefiningClass(), null);
			  String msgname = new MethodNameColumnLabel().getDisplayString(method, info);
							   
			  if (pgkname.equals(""))
				  return  (new StringBuffer(implname)).append(".").append(msgname).toString();    
			  else
				  return  (new StringBuffer(pgkname)).append(".").append(implname).append(".").append(msgname).toString();    
		  }
		  
		   
		   return ""; 
		 }

	
	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		return null;
	}
		
	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		return null;
	}		
}
