/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;

public class InheritedCumulativeTimeColumnLabel extends AbstractNumberColumnLabel {

	protected Number getValue(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
			return new Double(((TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getInheritedCumulativeTime());
		if (element instanceof TRCClass)
			return new Double(((TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getInheritedCumulativeTime());		

		return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
		{
			TRCPackageSnapshot delta = packageSnapshot();
			((TRCPackage)element).computeDelta(delta,TracePackage.TRC_PACKAGE__INHERITED_CUMULATIVE_TIME);
			return new Double(delta.getInheritedCumulativeTime());
		}
		if (element instanceof TRCClass)
		{
			TRCClassSnapshot delta = classSnapshot();			
			((TRCClass)element).computeDelta(delta,TracePackage.TRC_CLASS__INHERITED_CUMULATIVE_TIME);
			return new Double(delta.getInheritedCumulativeTime());
		}		
		
		return null;
	}		
	
	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);
		
		if (eObj instanceof TRCPackage)
			return IContextAttributes.PACKAGE_INH_CUMULATIVE_TIME;
		else if (eObj instanceof TRCClass)
			return IContextAttributes.CLASS_INH_CUMULATIVE_TIME;
		else
			return null;
	}			
}
