/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PackageNameColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class InstanceNameColumnLabel extends ColumnLabelAdapter {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		if (element == null)
			return "";
		
		TRCObject obj = getTRCObject(element, info);
		if (obj != null)
		{
			EObject eObj = ContextUpdaterHelper.getEObject(obj);
			IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.OBJECT_NAME, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				
			return formatter.getDisplayStringFromElement(String.valueOf(obj.getId()), obj, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		}

		return "";
    }
	
	protected TRCObject getTRCObject(Object element, ColumnDisplayInfo info)
	{
		if (element instanceof TRCObjectReference)
		{
			TRCObjectReference ref = (TRCObjectReference) element;
			
			TRCObject object = null;
			if(info.showReferTo)
			  object = ref.getOwner();
			else
			  object = ref.getTarget();  
			
			return object;
		}				    
		if (element instanceof TRCMethodInvocation)
			return ((TRCMethodInvocation)element).getOwningObject();
		if (element instanceof TRCObject)
			return (TRCObject)element;
		
		return null;
	}
	
	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		if (element == null)
			return null;
		
		TRCObject obj = getTRCObject(element, info);
		if (obj != null)
		{
			EObject eObj = ContextUpdaterHelper.getEObject(obj);
			IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.OBJECT_NAME, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
			
			return createImage(formatter.getDisplayImageByElement(String.valueOf(obj.getId()) ,element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		}

		return null;

	}
	
	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		return null;
	}
}
