/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;

public class LiveInstancesColumnLabel extends AbstractNumberColumnLabel {

	protected Number getValue(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
		{
			TRCPackageImpl.TRCPackageSnapshot ps = (TRCPackageImpl.TRCPackageSnapshot)((TRCPackage) element).retrieveSnapshot();		
			return new Integer(ps.getTotalInstances() - ps.getCollectedInstances());
		}
		if (element instanceof TRCClass)
		{
			TRCClassImpl.TRCClassSnapshot cs = (TRCClassImpl.TRCClassSnapshot)((TRCClass) element).retrieveSnapshot();		
			return new Integer(cs.getTotalInstances() - cs.getCollectedInstances());
		}
		
		return null;
	}

	protected Number getDelta(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCPackage)
		{
			TRCPackageSnapshot delta = packageSnapshot();
			((TRCPackage)element).computeDelta(delta,TracePackage.TRC_PACKAGE__TOTAL_INSTANCES);
			((TRCPackage)element).computeDelta(delta,TracePackage.TRC_PACKAGE__COLLECTED_INSTANCES);						
			return new Integer(delta.getTotalInstances() - delta.getCollectedInstances());
		}
		if (element instanceof TRCClass)
		{
			TRCClassSnapshot delta = classSnapshot();			
			((TRCClass)element).computeDelta(delta,TracePackage.TRC_CLASS__TOTAL_INSTANCES);
			((TRCClass)element).computeDelta(delta,TracePackage.TRC_CLASS__COLLECTED_INSTANCES);						
			return new Integer(delta.getTotalInstances() - delta.getCollectedInstances());
		}		
		
		return null;
	}
	
	protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);		
		
		if (eObj instanceof TRCPackage)
			return IContextAttributes.PACKAGE_LIVE_INST;
		else if (eObj instanceof TRCClass)
			return IContextAttributes.CLASS_LIVE_INST;
		else
			return null;
	}			
}
