/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PackageNameColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;


public class MethodInvocationColumnLabel extends MethodNameColumnLabel {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		if (element == null)
			return "";
		
		TRCMethod method = getTRCMethod(element, info);
		if (method != null)
		{
			EObject eObj = ContextUpdaterHelper.getEObject(element);
			IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.METHOD_INVOCATIONS, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);

			return formatter.getDisplayStringFromElement(method.getName(), method, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		}
		
		return "";
	}

	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		if (element == null)
			return null;
		
		TRCMethod method = getTRCMethod(element, info);
		if (method != null)
		{
			EObject eObj = ContextUpdaterHelper.getEObject(element);
			IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.METHOD_INVOCATIONS, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);

			return createImage(formatter.getDisplayImageByElement(method.getName(), method, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		}
		
		return null;
	}
	
	protected TRCMethod getTRCMethod(Object element, ColumnDisplayInfo info)
	{
		if (element instanceof TRCMethod)
			return (TRCMethod)element;
		if (element instanceof TRCMethodInvocation)
			return ((TRCMethodInvocation)element).getMethod();
		if (element instanceof Coverage)
			return getTRCMethod(((Coverage)element).getTraceObj(), info);
		
		return null;
	}
	
	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		return null;
	}
}
