/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class MethodInvocationEntryTimeColumnLabel extends ColumnLabelAdapter {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);
		IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.METHOD_START_TIME, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		
		if(element instanceof TRCFullMethodInvocation)
			return formatter.getDisplayStringFromElement(getValue(element), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);							  							 	
		 
		 return "";	
	}
	
	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);
		IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.METHOD_START_TIME, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		
		if(element instanceof TRCFullMethodInvocation)
			return createImage(formatter.getDisplayImageByElement(getValue(element), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		else
			return null;
	}
		
	public Double getValue(Object element) {
		return new Double(((TRCFullMethodInvocation)element).getEntryTime());
	}	
	
	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		if(element instanceof TRCFullMethodInvocation)
			return getValue(element);
		else
			return null;
	}		
}
