/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MethodQualifiedNameColumnLabel.java,v 1.2 2006/10/11 22:11:11 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.views.util.internal.AggregatedInvocation;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class MethodQualifiedNameColumnLabel extends ColumnLabelAdapter {
	
	private ClassNameColumnLabel classNameCol = new ClassNameColumnLabel();
	private MethodNameColumnLabel methodNameCol = new MethodNameColumnLabel();
	private PackageNameColumnLabel packageNameCol = new PackageNameColumnLabel();

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		if (element == null)
			return "";
		
		if (element instanceof AggregatedInvocation.Item)
		{
			TRCMethod method = ((AggregatedInvocation.Item)element).getMethod();
			String displayString = getDisplyStringFromMap(method);
			if (displayString==null)
			{
				TRCPackage pkg = method.getDefiningClass().getPackage();
				String cls = classNameCol.getDisplayString(method.getDefiningClass(), null);
				String mtd = methodNameCol.getDisplayString(method, info);
				
				displayString = cls + "." + mtd;
				if (!"".equals(pkg.getName())) {
					displayString = packageNameCol.getDisplayString(pkg, null) 
						+ "." + displayString;
				}
				
				displayStringMap.put(method,displayString);
			}	
			
			return displayString;
		}
		
		return "";
	}

	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		if (element == null)
			return null;
		
		if (element instanceof AggregatedInvocation.Item)
		{
			TRCMethod method = ((AggregatedInvocation.Item)element).getMethod();
			IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(method), IContextAttributes.METHOD_NAME, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);

			return createImage(formatter.getDisplayImageByElement(method.getName(), method, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		}
		
		return null;
	}

	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		return null;
	}
}
