/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class MethodsHitColumnLabel extends ColumnLabelAdapter {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		if (!(element instanceof Coverage))
			return "";
		
		Coverage cov = (Coverage) element;
		
		EObject eObj = ContextUpdaterHelper.getEObject(element);
		IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.COVERAGE_METHOD_HIT, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		return formatter.getDisplayStringFromElement(new Integer(cov.getMethodsHit()), cov.getTraceObj(), IContextLabelFormatProvider.MODE_COLUMN_CONTENT);		
		
	}

	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		if (!(element instanceof Coverage))
			return null;
		
		Coverage cov = (Coverage) element;
		
		EObject eObj = ContextUpdaterHelper.getEObject(element);
		IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.COVERAGE_METHOD_HIT, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		return createImage(formatter.getDisplayImageByElement(new Integer(cov.getMethodsHit()), cov.getTraceObj(), IContextLabelFormatProvider.MODE_COLUMN_CONTENT));		
	}

	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		if (!(element instanceof Coverage))
			return null;
		
		Coverage cov = (Coverage) element;	
		
		if (cov.getTraceObj() instanceof TRCMethod)
			return null;
		else
			return new Double(cov.getMethodsHit());
	}
}
