/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseTimeColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl.TRCClassSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl.TRCMethodSnapshot;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl.TRCPackageSnapshot;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.swt.graphics.Image;

public class NewItemColumnLabel extends ColumnLabelAdapter {
	
	public String getDisplayString(Object element, ColumnDisplayInfo info)
	{
		return "";
	}

	public Image getDisplayImage(Object element, ColumnDisplayInfo info)
	{
		if (newItem(element))
			return TracePluginImages.getImage(TracePluginImages.IMG_DELTANEW);
		else
			return null;
	}
	
	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		if (newItem(element))
			return new Double(1);
		else
			return new Double(-1);
	}	

	protected boolean newItem(Object element)
	{
		if (element instanceof TRCPackage)
		{
			TRCPackageSnapshot delta = packageSnapshot();			
			return ((TRCPackage)element).computeDelta(delta,TracePackage.TRC_PACKAGE__TOTAL_INSTANCES) < 0;
		}
		if (element instanceof TRCClass)
		{
			TRCClassSnapshot delta = classSnapshot();				
			return ((TRCClass)element).computeDelta(delta, TracePackage.TRC_CLASS__TOTAL_INSTANCES) < 0;
		}
		if (element instanceof TRCMethod)
		{
			TRCMethodSnapshot delta = methodSnapshot();				
			return ((TRCMethod)element).computeDelta(delta, TracePackage.TRC_METHOD__BASE_TIME) < 0;			
		}
		
		return false;
	}
}
