/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PackageNameColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class NumberReferencesColumnLabel extends ColumnLabelAdapter {
	
	protected int getValue(Object element, ColumnDisplayInfo info) {
		
		if (element instanceof TRCObjectReference)
		{
			TRCObjectReference ref = (TRCObjectReference) element;		
			
			if(info.showReferTo)
			{
			   int nb = 0;
			   Object[] list = ref.getOwner().getRefTarget().toArray();
			   int size = list.length;
			   for(int idx=0; idx<size; idx++)
			   {
			   	   if(list[idx] instanceof TRCAggregatedObjectReference)
			   	   	nb += ((TRCAggregatedObjectReference)list[idx]).getCount();
			   	   else 
			   	     nb++;	
			   }
			   return nb;
			}
			else
			{
				int nb = 0;
				Object[] list = ref.getTarget().getRefOwner().toArray();
				int size = list.length;
			    for(int idx=0; idx<size; idx++)
			    {
				   if(list[idx] instanceof TRCAggregatedObjectReference)							   	
			   	   	 nb += ((TRCAggregatedObjectReference)list[idx]).getCount();
			   	   else
			   	     nb++;	 
			    }
			    return nb;		
			}
		}
		
		return 0;
	}

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		
		if(info.showReferTo)
		{
			if (element instanceof TRCObjectReference)
			{
				int nb = getValue(element, info);
				   
				EObject eObj = ContextUpdaterHelper.getEObject(element);
				IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.REF_NUMBER_TO, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				return formatter.getDisplayStringFromElement(new Integer(nb), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);		
			}
			else if (element instanceof TRCHeapObject)
			{
				TRCHeapObject object = (TRCHeapObject)element;
		        
				int nb = 0;
				int size = object.getRefTarget().size();
				for(int idx=0; idx<size; idx++)
				{
					if(object.getRefTarget().get(idx) instanceof TRCAggregatedObjectReference)							   	
						nb += ((TRCAggregatedObjectReference)object.getRefTarget().get(idx)).getCount();
					else
					  nb++;	 
				}

				EObject eObj = ContextUpdaterHelper.getEObject(element);
				IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.REF_NUMBER_TO, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				return formatter.getDisplayStringFromElement(new Integer(nb), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);		
			}
		}
		else
		{
			if (element instanceof TRCObjectReference)
			{
				int nb = getValue(element, info);
				
				EObject eObj = ContextUpdaterHelper.getEObject(element);
				IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.REF_NUMBER_BY, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				return formatter.getDisplayStringFromElement(new Integer(nb), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);		
			}
			else if (element instanceof TRCHeapObject)
			{
				TRCHeapObject object = (TRCHeapObject)element;
		        
				int nb = 0;
				int size = object.getRefOwner().size();
				for(int idx=0; idx<size; idx++)
				{
					if(object.getRefOwner().get(idx) instanceof TRCAggregatedObjectReference)
						nb += ((TRCAggregatedObjectReference)object.getRefOwner().get(idx)).getCount();
					else
						nb++;	 
				}
				   
				EObject eObj = ContextUpdaterHelper.getEObject(element);
				IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.REF_NUMBER_BY, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				return formatter.getDisplayStringFromElement(new Integer(nb), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);		
			}
		}
		
		return "";
    }

	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		return null;
	}
	
	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCHeapObject)
			return null;
		else
			return new Double(getValue(element, info));
	}
}
