/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PackageNameColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class PackageNameColumnLabel extends ColumnLabelAdapter {
	
	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		if (element == null)
			return "";
		
		TRCPackage pack = getTRCPackage(element, info);
		
		if (pack != null)
		{
				String displayString = getDisplyStringFromMap(pack);
				if (displayString==null) 
				{
					EObject eObj = ContextUpdaterHelper.getEObject(element);
	
					IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.PACKAGE_NAME, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		
					displayString = formatter.getDisplayStringFromElement(pack.getName(), pack, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
					
					displayStringMap.put(pack,displayString);
				}	
			    
				if (info == null || info.mofObject instanceof TRCAgentProxy || info.mofObject instanceof TRCProcessProxy) {
					return displayString;
			    }
			        
			    return displayString+" ["+pack.getProcess().getPid()+"]";
		}
		
		return "";
		
	}
	
	protected TRCPackage getTRCPackage(Object element, ColumnDisplayInfo info)
	{
		if (element==null) return null;
		
		if (element instanceof TRCPackage)
			return (TRCPackage)element;
		if (element instanceof TRCClass)
			return ((TRCClass)element).getPackage();		
		if (element instanceof TRCMethod) {
			if (((TRCMethod) element).getDefiningClass() != null)
				return ((TRCMethod) element).getDefiningClass().getPackage();
			else
				return null;
		}
		if (element instanceof TRCObjectReference)
		{
			TRCObjectReference ref = (TRCObjectReference)element;
			TRCObject object = null;
			
			if(info.showReferTo)
			  object = ref.getOwner();
			else
			  object = ref.getTarget();  
			
			return PerftraceUtil.getClass(object).getPackage();
		}
		if (element instanceof TRCObject)
			return PerftraceUtil.getClass((TRCObject)element).getPackage();
		if (element instanceof Coverage)
			return getTRCPackage(((Coverage)element).getTraceObj(), info);
		
		return null;		
	}
	
	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		
		if(element == null)
			return null;
		TRCPackage pack = getTRCPackage(element, info);
		
		if (pack != null)
		{
			EObject eObj = ContextUpdaterHelper.getEObject(element);
			
			IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.PACKAGE_NAME, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
			return createImage(formatter.getDisplayImageByElement(pack.getName(), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
		}
		
		return null;

	}
	
	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		return null;
	}
		
}
