/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PackageNameColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class ReferenceDetailColumnLabel extends ColumnLabelAdapter {
	
	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		
		EObject eObj = ContextUpdaterHelper.getEObject(element);
	   
		if (element instanceof TRCObjectReference)
		{
			TRCObjectReference ref = (TRCObjectReference) element;
			
		   if(ref instanceof TRCAggregatedObjectReference)
		   {
				int size = ((TRCAggregatedObjectReference)ref).getCount();
			    
				IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), info.showReferTo?IContextAttributes.REF_DETAILS_TO:IContextAttributes.REF_DETAILS_BY, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				return formatter.getDisplayStringFromElement(new Integer(size), ref, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);  
		   }		
		}
		
		return "";
    }

	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		return null;
	}

	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		if(element instanceof TRCAggregatedObjectReference)
	    	return new Double(((TRCAggregatedObjectReference)element).getCount());
		else
			return null;		
	}
}
