/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PackageNameColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class ReferenceSizeColumnLabel extends ColumnLabelAdapter {
	
	private int getValueObjRefClas(Object element, ColumnDisplayInfo info) {
		
		if (element instanceof TRCObjectReference)
		{
			TRCObjectReference ref = (TRCObjectReference) element;
			
			if(ref instanceof TRCAggregatedObjectReference)
			{
				if(info.showReferTo)
					return ((TRCAggregatedObjectReference)ref).getOwnerSize();								
				else
					return ((TRCAggregatedObjectReference)ref).getTargetSize();
			}
			else
			{
				if(info.showReferTo)
				   return ref.getOwner().getSize();								
				else
				   return ref.getTarget().getSize();
			}
		}
		if (element instanceof TRCClass)
			return ((TRCClass)element).getTotalSize() - ((TRCClass)element).getCollectedSize();
		
		return 0;
	}
	
	private int getValueHeapObject(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCHeapObject)
		{
		
	        TRCHeapObject object = (TRCHeapObject)element;
	        
			int size = object.getSize(); //total size
			
			if(size != 0)
			  return size;
			  
			//collect statistic information mode
			if(info.showReferTo)
			{
			   if(object.getRefTarget().size() > 0 && object.getRefTarget().get(0) instanceof TRCAggregatedObjectReference)
			   {
			   	   return ((TRCAggregatedObjectReference)object.getRefTarget().get(0)).getTargetSize();
			   }
			   else
			   {
					TRCClass clas = PerftraceUtil.getClass(object);
					int instSize = clas.getTotalInstances();
					if(instSize == 0) instSize = 1;
					
					return (int) clas.getTotalSize()/instSize;
			   }
			}
			else
			{
			   if(object.getRefOwner().size() > 0 && object.getRefOwner().get(0) instanceof TRCAggregatedObjectReference)
			   {
			   	   return ((TRCAggregatedObjectReference)object.getRefOwner().get(0)).getOwnerSize();
			   }
			   else
			   {
					TRCClass clas = PerftraceUtil.getClass(object);
					int instSize = clas.getTotalInstances();
					if(instSize == 0) instSize = 1;
					
					return (int) clas.getTotalSize()/instSize;
			   }
			}
		}
		return 0;
	}

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		EObject eObj = ContextUpdaterHelper.getEObject(element);
		IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(ContextUpdaterHelper.getContext(eObj), IContextAttributes.REF_SIZE, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
			
		if (element instanceof TRCObjectReference || element instanceof TRCClass)
			return formatter.getDisplayStringFromElement(new Integer(getValueObjRefClas(element, info)), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		if (element instanceof TRCHeapObject)
			return formatter.getDisplayStringFromElement(new Integer(getValueHeapObject(element, info)), element, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
				
		return "";
    }

	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCObjectReference || element instanceof TRCClass)
			return new Double(getValueObjRefClas(element, info));
		if (element instanceof TRCHeapObject)
			return new Double(getValueHeapObject(element, info));
		
		return null;
	}

	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		return null;
	}
}
