/**********************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ThreadMethodInvocationNameColumnLabel.java,v 1.3 2006/10/23 17:07:49 ewchan Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.util.internal.AggregatedInvocation;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class ThreadMethodInvocationNameColumnLabel extends ColumnLabelAdapter {

	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {		
		return null;
	}

	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCThread) {
            return TracePluginImages.getImage(TracePluginImages.IMG_THREAD);
		} else  if (element instanceof AggregatedInvocation) {			
            return TracePluginImages.getImage(TracePluginImages.IMG_METHOD);
		}
		return null;
	}

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		if (element instanceof TRCThread) {
			TRCThread thread = (TRCThread) element;
			EObject eObj = ContextUpdaterHelper.getEObject(element);
			IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(eObj), IContextAttributes.THREAD_NAME, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);

			return formatter.getDisplayStringFromElement(thread.getName(), thread, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
		} else  if (element instanceof AggregatedInvocation) {
			TRCMethod method = ((AggregatedInvocation)element).getMethod();
			if (method != null)
			{
				IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(method), IContextAttributes.METHOD_INVOCATIONS, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);

				return formatter.getDisplayStringFromElement(method.getName(), method, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
			}			
		}
		return "";
	}
}
