/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PackageNameColumnLabel.java
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 *********************************************************************/
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextAttributes;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class ThreadNameColumnLabel extends ColumnLabelAdapter {

	public String getDisplayString(Object element, ColumnDisplayInfo info) {
		TRCThread thread = (TRCThread) ContextUpdaterHelper.getEObject(element);
		IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(thread), IContextAttributes.THREAD_NAME, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);

		return formatter.getDisplayStringFromElement(thread.getName(), thread, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);
	}

	public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
		TRCThread thread = (TRCThread) ContextUpdaterHelper.getEObject(element);
		IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider(getContext(thread), IContextAttributes.THREAD_NAME, IContextLabelFormatProvider.MODE_COLUMN_CONTENT);

		return createImage(formatter.getDisplayImageByElement(thread.getName(), thread, IContextLabelFormatProvider.MODE_COLUMN_CONTENT));
	}
	
	public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
		return null;
	}
}
