/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphColorPreferencePage.java,v 1.2 2007/04/05 04:17:05 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.preferences.internal;

import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.GraphColorUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

/*
* CONTEXT_ID tcpp0000 for Console preference page
*/

/**
 * A page to set the preferences for the console
 */
public class GraphColorPreferencePage extends PreferencePage
										implements IWorkbenchPreferencePage
{
	private GraphColorUI _colorUI;
		
	/**
	 * Create the console page.
	 */
	public GraphColorPreferencePage() {
		
	}
	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {

		PlatformUI.getWorkbench().getHelpSystem().setHelp(
		parent,
		TraceUIPlugin.getPluginId()+".gcpp0000");
		
		_colorUI = new GraphColorUI();
		Control composite = _colorUI.createContents( parent );
		Dialog.applyDialogFont( composite );
		
		return composite;
								
	}
			
	/**
	 * @see IWorkbenchPreferencePage#init
	 */
	public void init(IWorkbench workbench) {
	}
	
	/**
	 * Defaults was clicked. Restore the CVS preferences to
	 * their default values
	 */
	protected void performDefaults() {
		super.performDefaults();
		
		_colorUI.performDefaults();
	}
	
	/**
	 * OK was clicked. Store the CVS preferences.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		
		return _colorUI.performOk();
	}

	/**
	 * Returns the font data that describes the font to use for views
	 */
	public static FontData getConsoleFontData() {
		
		return GraphColorUI.getConsoleFontData();
	}
		
}
