/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ColumnsDialog.java,v 1.9 2010/05/12 20:02:33 kchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;

import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

/**
 * Insert the type's description here.
 * Creation date: (3/7/2001 1:44:48 PM)
 * @author: Administrator
 */
public class ColumnsDialog extends Dialog implements SelectionListener {
	
	private Table _list;
	private ArrayList _nonVisibleList;
	private Button _moveUp;
	private Button _moveDown;
	private ArrayList _data;
	private String _defaultColumnsTemplate;
	private static final int _restoreDefaultsButtonId = IDialogConstants.CLIENT_ID + 1;
	private String _contextHelpId;
	private String _context;

	private Spinner _columnWidth;
	
	private java.lang.String _title;
	/**
	 * CoulmnsDialog constructor comment.
	 * 
	 * @param windowTitle
	 *            java.lang.String
	 * @param windowImage
	 *            org.eclipse.swt.graphics.Image
	 */
	public ColumnsDialog(Shell shell, String windowTitle, Image windowImage, ArrayList data, String defaultColumnsTemplate, String contextHelpId,String context) {
		super(shell);
		_title = windowTitle;
		_defaultColumnsTemplate = defaultColumnsTemplate;
		setDefaultImage(windowImage);
		
		_contextHelpId = contextHelpId;
		
		_data = new ArrayList(data.size());
		_data.addAll(data);
		_context=context;
	}
	/**
	 * Configures the given shell in prepartaion for opening this window
	 * in it.
	 * <p>
	 * The default implementation of this framework method
	 * sets the shell's image and gives it a grid layout. 
	 * Subclasses may extend or reimplement.
	 * </p>
	 * 
	 * @param newShell the shell
	 */
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}
	/**
	 * Creates and returns the contents of the upper part 
	 * of the dialog (above the button bar).
	 *
	 * Subclasses should overide.
	 *
	 * @param the parent composite to contain the dialog area
	 * @return the dialog area control
	 */
	protected Control createDialogArea(Composite parent) {
		Composite result = (Composite) super.createDialogArea(parent);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 3;
		layout.verticalSpacing = 15;
		result.setLayout(layout);
		result.setLayoutData(GridUtil.createFill());

		Label description = new Label(result, SWT.NONE);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 3;
		description.setLayoutData(data);

		description.setText(TraceUIMessages._63);

		Group dataComp = new Group(result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		dataComp.setLayout(layout);
		data = GridUtil.createFill();
		data.horizontalSpan = 2;
		dataComp.setLayoutData(data);
		dataComp.setText(TraceUIMessages.columnsGroup);
		
		_list = new Table(dataComp, SWT.BORDER | SWT.CHECK | SWT.H_SCROLL);
		data = GridUtil.createFill();
		data.horizontalSpan = 2;
		_list.setLayoutData(data);

		Composite buttonWidget = new Composite(result, SWT.NULL);
		data = new GridData();
		data.grabExcessVerticalSpace = true;
		data.verticalAlignment = GridData.FILL;
		buttonWidget.setLayoutData(data);
		GridLayout blayout = new GridLayout();
		blayout.numColumns = 1;
		buttonWidget.setLayout(blayout);

		_moveUp = new Button(buttonWidget, SWT.NULL);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_moveUp.setLayoutData(data);
		_moveUp.setText(TraceUIMessages._64);

		_moveDown = new Button(buttonWidget, SWT.NULL);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_moveDown.setLayoutData(data);
		_moveDown.setText(TraceUIMessages._65);

		_list.addSelectionListener(this);
		_moveUp.addSelectionListener(this);
		_moveDown.addSelectionListener(this);

		_moveUp.setEnabled(false);
		_moveDown.setEnabled(false);

		// Bug 308106
		Label columnWidthLabel = new Label(dataComp, SWT.NONE);
		columnWidthLabel.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, true, false, 1, 1));
		columnWidthLabel.setText(TraceUIMessages.columnWidth);
		_columnWidth = new Spinner(dataComp, SWT.NONE);
		_columnWidth.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		_columnWidth.setMinimum(10);
		_columnWidth.setMaximum(1000);
		_columnWidth.setPageIncrement(10);
		_columnWidth.setTextLimit(4);
		_columnWidth.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				
				Spinner spinner = (Spinner)e.widget;
				ColumnData cdata = (ColumnData)spinner.getData();				
				
				if( cdata != null ) {
					cdata.width( spinner.getSelection() );
				}
			}
		});
		
		// Select the label focuses the spinner
		columnWidthLabel.addFocusListener(new FocusAdapter() {
			public void focusGained(FocusEvent e) {
				_columnWidth.setFocus();
			}
		});
		
		_nonVisibleList = new ArrayList();
		
		if (_contextHelpId != null)
			PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, _contextHelpId);
		
		populateList();

		return result;
	}
	
	protected void columnSelected(int idx) {
		
		ColumnData data = (idx >= 0 && idx < _list.getItemCount()) ? (ColumnData)_list.getItem(idx).getData() : null;
		
		if( data != null && _list.getItem(idx).getChecked() ) {
			_columnWidth.setEnabled(true);
			_columnWidth.setData(data);
			_columnWidth.setSelection(data.width());
		} else {
			_columnWidth.setEnabled(false);
			_columnWidth.setData(null);
		}
	}

	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, _restoreDefaultsButtonId, TraceUIMessages._86, false);
		super.createButtonsForButtonBar(parent);
	}

	protected void buttonPressed(int buttonId) {
		if (buttonId == _restoreDefaultsButtonId) {
			_data.clear();
			_data.addAll(ColumnData.createColumnDataFromString(_defaultColumnsTemplate));
			
			for (int idx = 0; idx < _data.size(); idx++) {
				ColumnData data = (ColumnData) _data.get(idx);
				data.setContext(_context);
			}
			
			populateList();
		}
		else {
			super.buttonPressed(buttonId);
		}
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (3/8/2001 4:13:01 PM)
	 * @return java.util.ArrayList
	 */
	public ArrayList getData() {
		return _data;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/7/2001 3:30:47 PM)
	 * @param idx int
	 */
	protected void moveDown(int idx) {
		TableItem item = _list.getItem(idx);
		ColumnData data = (ColumnData) item.getData();
		if (!data.isMovable())
			return;
		TableItem newitem = new TableItem(_list, SWT.CHECK, idx + 2);
		newitem.setChecked(item.getChecked());
		newitem.setText(item.getText());

		newitem.setData(data);

		newitem.setGrayed(item.getGrayed());

		_list.remove(idx);

		_list.select(idx + 1);

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/7/2001 3:30:47 PM)
	 * @param idx int
	 */
	protected void moveUp(int idx) {
		TableItem item = _list.getItem(idx);

		ColumnData data = (ColumnData) item.getData();

		if (!data.isMovable())
			return;
		if (idx > 0) {
			TableItem previousItem = _list.getItem(idx - 1);
			ColumnData previousItemData = (ColumnData) previousItem.getData();
			if (!previousItemData.isMovable())
				return;
		}

		TableItem newitem = new TableItem(_list, SWT.CHECK, idx - 1);
		newitem.setChecked(item.getChecked());
		newitem.setText(item.getText());

		newitem.setData(data);
		newitem.setGrayed(item.getGrayed());

		_list.remove(idx + 1);

		_list.select(idx - 1);
	}
	/**
	 * Notifies that the ok button of this dialog has been pressed.
	 * <p>
	 * The default implementation of this framework method sets
	 * this dialog's return code to <code>Window.OK</code>
	 * and closes the dialog. Subclasses may override.
	 * </p>
	 */
	protected void okPressed() {
		if (!validate()) {
			org.eclipse.jface.dialogs.MessageDialog.openError(getShell(), TraceMessages.TRC_MSGT
					, TraceUIMessages._70);

			return;
		}

		_data.clear();
		
		int idx = 0;
		int nvIdx = 0;

		while ( idx < _list.getItemCount() ||				
				nvIdx < _nonVisibleList.size()) {
			
			ColumnData data = null;
			
			boolean checked = true;
			
			if (nvIdx < _nonVisibleList.size())
			{
				data = (ColumnData) _nonVisibleList.get(nvIdx);
				
				if (data.getInitalPos() == _data.size())
				{
					checked = true;
					nvIdx++;
				}
				else
					data = null;
			}
			
			if (data == null)
			{
				TableItem item = _list.getItem(idx);
				data = (ColumnData) item.getData();
				checked = item.getChecked();
				idx++;				
			}
			
			
			int style = data.getStyle();
			if (checked)
				style |= ColumnData.IS_VISIBLE;
			else
				style &= ~ColumnData.IS_VISIBLE;
			_data.add(
				new ColumnData(
					data.key(),
					data.getInitalPos(),
					style,
					data.getAlignment(),
					data.width()
					));
		}

		super.okPressed();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/7/2001 3:05:18 PM)
	 */
	private void populateList() {
		_list.removeAll();
		
		while (_nonVisibleList.size() > 0)
			_nonVisibleList.remove(0);
		
		for (int idx = 0; idx < _data.size(); idx++) {
			ColumnData data = (ColumnData) _data.get(idx);

			if (data.visibleChooseColumns())
			{
	 			TableItem item = new TableItem(_list, SWT.NONE);
				item.setText(data.name());
				item.setChecked(data.visible() == true);
				item.setGrayed(data.isNonDeletable());
				item.setData(data);
			}
			else
			{
				_nonVisibleList.add(data);
			}
		}
		
		columnSelected(_list.getSelectionIndex());
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (5/30/2001 4:36:22 PM)
	 */
	private boolean validate() {
		boolean valid = false;

		for (int idx = 0; idx < _list.getItemCount(); idx++) {
			TableItem item = _list.getItem(idx);

			if (item.getChecked())
				return true;
		}

		return valid;

	}
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		if (e.widget == _moveUp) {
			int idx = _list.getSelectionIndex();

			if (idx > 0)
				moveUp(idx);
		}
		else if (e.widget == _moveDown) {
			int idx = _list.getSelectionIndex();

			if (idx != -1 && (idx < _list.getItemCount() - 1))
				moveDown(idx);
		}

		else if (e.widget instanceof Table) {
			// Don't let the user uncheck a non-deletable column
			TableItem items[] = _list.getItems();
			for (int x = 0; x < items.length; x++) {
				boolean checked = items[x].getChecked();
				ColumnData d = (ColumnData) items[x].getData();
				if (!checked && d.isNonDeletable()) {
					items[x].setChecked(true);
				}
			}
		}

		int idx = _list.getSelectionIndex();

		ColumnData data = null;
		ColumnData previousData = null;
		if (idx > 0) {
			previousData = (ColumnData) _list.getItem(idx - 1).getData();
		}
		if (idx != -1) {
			data = (ColumnData) _list.getItem(idx).getData();
		}
		_moveUp.setEnabled(data != null && data.isMovable() && previousData != null && previousData.isMovable());
		_moveDown.setEnabled(data != null && data.isMovable() && (idx < _list.getItemCount() - 1));

		// Bug 308106
		columnSelected(idx);
	}
}