/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphColorDialog.java,v 1.4 2005/08/10 02:37:48 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.trace.views.internal.*;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 * @author popescu
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 */
public class GraphColorDialog extends Dialog
{
	private static final int _restoreDefaultsButtonId = IDialogConstants.CLIENT_ID + 1;	
	private java.lang.String _title;
	
	private GraphColorUI _colorUI;
	
	/**
	 * CoulmnsDialog constructor comment.
	 * @param windowTitle java.lang.String
	 * @param windowImage org.eclipse.swt.graphics.Image
	 */
	public GraphColorDialog(Shell shell, String windowTitle, Image windowImage) {
		super(shell);
		_title = windowTitle;
		setDefaultImage(windowImage);
	}
	/**
	 * Configures the given shell in prepartaion for opening this window
	 * in it.
	 * <p>
	 * The default implementation of this framework method
	 * sets the shell's image and gives it a grid layout. 
	 * Subclasses may extend or reimplement.
	 * </p>
	 * 
	 * @param newShell the shell
	 */
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}
	/**
	 * Creates and returns the contents of the upper part 
	 * of the dialog (above the button bar).
	 *
	 * Subclasses should overide.
	 *
	 * @param the parent composite to contain the dialog area
	 * @return the dialog area control
	 */
	protected Control createDialogArea(Composite parent) {
		Composite result = (Composite) super.createDialogArea(parent);

		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		result.setLayout(layout);

		_colorUI = new GraphColorUI();
		_colorUI.createContents(result);

		return result;
	}

	protected void createButtonsForButtonBar(Composite parent) {
		createButton(
			parent,
			_restoreDefaultsButtonId,
			TraceUIMessages._86,
			false);
		super.createButtonsForButtonBar(parent);
	}

	protected void buttonPressed(int buttonId) {
		if (buttonId == _restoreDefaultsButtonId) {
			
			_colorUI.performDefaults();
		} else {
			super.buttonPressed(buttonId);
		}
	}

	/**
	* Notifies that the ok button of this dialog has been pressed.
	* <p>
	* The default implementation of this framework method sets
	* this dialog's return code to <code>Window.OK</code>
	* and closes the dialog. Subclasses may override.
	* </p>
	*/
	protected void okPressed() {

        _colorUI.performOk();

		super.okPressed();
	}

}