/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphColorUI.java,v 1.4 2005/08/10 02:37:48 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.trace.ui.internal.util.ColorEditor;
import org.eclipse.hyades.trace.views.adapter.internal.TraceConstants;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class GraphColorUI
{	
	private FontFieldEditor fontEditor;

	private ColorEditor fClassColorEditor;
	private ColorEditor fBackgroundColorEditor;
	private Button fBackgroundDefaultRadioButton;
	private Button fBackgroundCustomRadioButton;
	private Button fBackgroundColorButton;
	
	private Button fClassCustomRadioButton;	
	private Button fClassDefaultRadioButton;	
	private Button fClassColorButton;
	
	private ColorEditor fSelectionColorEditor;
	private Button fSelectionColorButton;
	private ColorEditor fUnknownColorEditor;
	private Button fUnknownColorButton;
	
	/**
	 * Create the console page.
	 */
	public GraphColorUI() {
		
	}
	/**
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
	 */
	public Control createContents(Composite parent) {
		
		Composite colorComposite= new Composite(parent, SWT.NULL);
		colorComposite.setLayout(new GridLayout());

		Composite backgroundComposite= new Composite(colorComposite, SWT.NULL);
		GridLayout layout= new GridLayout();
		layout.marginHeight= 0;
		layout.marginWidth= 0;
		layout.numColumns= 2;
		backgroundComposite.setLayout(layout);

		Label label= new Label(backgroundComposite, SWT.NULL);
		label.setText(TraceUIMessages._88);
		GridData gd= new GridData();
		gd.horizontalSpan= 2;
		label.setLayoutData(gd);

		SelectionListener backgroundSelectionListener= new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {				
				boolean custom= fBackgroundCustomRadioButton.getSelection();
				fBackgroundColorButton.setEnabled(custom);
			}
			public void widgetDefaultSelected(SelectionEvent e) {}
		};

		fBackgroundDefaultRadioButton= new Button(backgroundComposite, SWT.RADIO | SWT.LEFT);
		fBackgroundDefaultRadioButton.setText(TraceUIMessages._89);
		gd= new GridData();
		gd.horizontalSpan= 2;
		fBackgroundDefaultRadioButton.setLayoutData(gd);
		fBackgroundDefaultRadioButton.addSelectionListener(backgroundSelectionListener);

		fBackgroundCustomRadioButton= new Button(backgroundComposite, SWT.RADIO | SWT.LEFT);
		fBackgroundCustomRadioButton.setText(TraceUIMessages._90);
		fBackgroundCustomRadioButton.addSelectionListener(backgroundSelectionListener);

		fBackgroundColorEditor= new ColorEditor(backgroundComposite);
		fBackgroundColorButton= fBackgroundColorEditor.getButton();
		gd= new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalAlignment= GridData.BEGINNING;
		fBackgroundColorButton.setLayoutData(gd);

		Composite classComposite= new Composite(colorComposite, SWT.NULL);
		layout= new GridLayout();
		layout.marginHeight= 0;
		layout.marginWidth= 0;
		layout.numColumns= 2;
		classComposite.setLayout(layout);

		label= new Label(classComposite, SWT.NULL);
		gd= new GridData();
		gd.horizontalSpan= 2;
		label.setLayoutData(gd);

		label= new Label(classComposite, SWT.NULL);
		label.setText(TraceUIMessages._91);
		gd= new GridData();
		gd.horizontalSpan= 2;
		label.setLayoutData(gd);

		SelectionListener classSelectionListener= new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {				
				boolean custom= fClassCustomRadioButton.getSelection();
				fClassColorButton.setEnabled(custom);
			}
			public void widgetDefaultSelected(SelectionEvent e) {}
		};

		fClassDefaultRadioButton= new Button(classComposite, SWT.RADIO | SWT.LEFT);
		fClassDefaultRadioButton.setText(TraceUIMessages._92);
		gd= new GridData();
		gd.horizontalSpan= 2;
		fClassDefaultRadioButton.setLayoutData(gd);
		fClassDefaultRadioButton.addSelectionListener(classSelectionListener);

		fClassCustomRadioButton= new Button(classComposite, SWT.RADIO | SWT.LEFT);
		fClassCustomRadioButton.setText(TraceUIMessages._93);
		fClassCustomRadioButton.addSelectionListener(classSelectionListener);

		fClassColorEditor= new ColorEditor(classComposite);
		fClassColorButton= fClassColorEditor.getButton();
		gd= new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalAlignment= GridData.BEGINNING;
		fClassColorButton.setLayoutData(gd);

		Composite otherComposite= new Composite(colorComposite, SWT.NULL);
		layout= new GridLayout();
		layout.marginHeight= 0;
		layout.marginWidth= 0;
		layout.numColumns= 2;
		otherComposite.setLayout(layout);
		
		label= new Label(otherComposite, SWT.NULL);
		gd= new GridData();
		gd.horizontalSpan= 2;
		label.setLayoutData(gd);
		
		label= new Label(otherComposite, SWT.LEFT);
		label.setText(TraceUIMessages._94);
		gd= new GridData();
		gd.horizontalAlignment= GridData.BEGINNING;		
		label.setLayoutData(gd);
		
		fUnknownColorEditor= new ColorEditor(otherComposite);
		fUnknownColorButton= fUnknownColorEditor.getButton();
		gd= new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalAlignment= GridData.BEGINNING;
		fUnknownColorButton.setLayoutData(gd);

		label= new Label(otherComposite, SWT.LEFT);
		label.setText(TraceUIMessages._95);
		gd= new GridData();
		gd.horizontalAlignment= GridData.BEGINNING;		
		label.setLayoutData(gd);
		
		fSelectionColorEditor= new ColorEditor(otherComposite);
		fSelectionColorButton= fClassColorEditor.getButton();
		gd= new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalAlignment= GridData.BEGINNING;
		fSelectionColorButton.setLayoutData(gd);
		
		label= new Label(otherComposite, SWT.NULL);
		gd= new GridData();
		gd.horizontalSpan= 2;
		label.setLayoutData(gd);
		
		Composite textComposite= new Composite(colorComposite, SWT.NULL);
		layout= new GridLayout();
		layout.marginHeight= 0;
		layout.marginWidth= 0;
		layout.numColumns= 3;
		textComposite.setLayout(layout);
		
		fontEditor = createFontFieldEditor(TraceConstants._96, TraceUIMessages._96, textComposite);
						
		initializeValues();
		return colorComposite;
	}
			
	
	/**
	 * Creates a new text field editor.
	 */
	private FontFieldEditor createFontFieldEditor(String preferenceName, String label, Composite parent) {
		FontFieldEditor editor = new FontFieldEditor(preferenceName, label, parent);
		editor.setPreferenceStore(getPreferenceStore());
		return editor;
	}
	
	
	/**
	* Returns preference store that belongs to the our plugin.
	* This is important because we want to store
	* our preferences separately from the desktop.
	*
	* @return the preference store for this plugin
	*/
	public IPreferenceStore getPreferenceStore() {
		return TraceUIPlugin.getDefault().getPreferenceStore(); 
	}
		
	
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {
		IPreferenceStore store = getPreferenceStore();
	
		fontEditor.load();	
		
		String backgroundValue = store.getString(TraceConstants.BACKGROUND_OPTION);	
		if(backgroundValue.equals(TraceConstants._89))
		{
			fBackgroundDefaultRadioButton.setSelection(true);
			fBackgroundColorButton.setEnabled(false);			
			
		}
		else
		{
			fBackgroundCustomRadioButton.setSelection(true);
			fBackgroundColorButton.setEnabled(true);									
		}
			
		String classesValue = store.getString(TraceConstants.CLASSES_OPTION);	
		if(!classesValue.equals(TraceConstants.CLASS_ONE_COLOR))
		{
			fClassDefaultRadioButton.setSelection(true);
			fClassColorButton.setEnabled(false);						
		}
		else
		{
			fClassCustomRadioButton.setSelection(true);	
			fClassColorButton.setEnabled(true);								
		}	
		
		RGB rgb= PreferenceConverter.getColor(store, TraceConstants.BACKGROUND_RGB);
		fBackgroundColorEditor.setColorValue(rgb);

		rgb= PreferenceConverter.getColor(store, TraceConstants.SELECTION_RGB);
		fSelectionColorEditor.setColorValue(rgb);

		rgb= PreferenceConverter.getColor(store, TraceConstants.UNKNOWN_RGB);
		fUnknownColorEditor.setColorValue(rgb);

		rgb= PreferenceConverter.getColor(store, TraceConstants.CLASSES_RGB);
		fClassColorEditor.setColorValue(rgb);
		
	}
	
	
	/**
	 * Returns the a color based on the type.
	 */
	public static Color getPreferenceColor(String type) {
		IPreferenceStore pstore= TraceUIPlugin.getDefault().getPreferenceStore();
		RGB outRGB= PreferenceConverter.getColor(pstore, type);
		return SpectrumColorMap.getColor(outRGB);
	}
	
	/**
	 * Defaults was clicked. Restore the CVS preferences to
	 * their default values
	 */
	public void performDefaults() {
		
		IPreferenceStore store = getPreferenceStore();
	
		fontEditor.loadDefault();	
		
		String backgroundValue = store.getDefaultString(TraceConstants.BACKGROUND_OPTION);	
		if(backgroundValue.equals(TraceConstants._89))
		{
			fBackgroundDefaultRadioButton.setSelection(true);
			fBackgroundCustomRadioButton.setSelection(false);
			fBackgroundColorButton.setEnabled(false);						
		}
		else
		{
			fBackgroundCustomRadioButton.setSelection(true);
			fBackgroundDefaultRadioButton.setSelection(false);
			fBackgroundColorButton.setEnabled(true);			
						
		}
			
		String classesValue = store.getDefaultString(TraceConstants.CLASSES_OPTION);	
		if(!classesValue.equals(TraceConstants.CLASS_ONE_COLOR))
		{
			fClassDefaultRadioButton.setSelection(true);
			fClassCustomRadioButton.setSelection(false);
			fClassColorButton.setEnabled(false);			
			
		}
		else
		{
			fClassCustomRadioButton.setSelection(true);
			fClassDefaultRadioButton.setSelection(false);
			fClassColorButton.setEnabled(true);			
						
		}	
		
		RGB rgb= PreferenceConverter.getDefaultColor(store, TraceConstants.BACKGROUND_RGB);
		fBackgroundColorEditor.setColorValue(rgb);

		rgb= PreferenceConverter.getDefaultColor(store, TraceConstants.SELECTION_RGB);
		fSelectionColorEditor.setColorValue(rgb);

		rgb= PreferenceConverter.getDefaultColor(store, TraceConstants.UNKNOWN_RGB);
		fUnknownColorEditor.setColorValue(rgb);

		rgb= PreferenceConverter.getDefaultColor(store, TraceConstants.CLASSES_RGB);
		fClassColorEditor.setColorValue(rgb);
		
	}
	
	/**
	 * OK was clicked. Store the CVS preferences.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		IPreferenceStore store = getPreferenceStore();
		
		fontEditor.store();
		
		if(fBackgroundDefaultRadioButton.getSelection())
		{
			store.setValue(TraceConstants.BACKGROUND_OPTION, TraceConstants._89);
			fBackgroundColorButton.setEnabled(false);
		}
		else
		{
			store.setValue(TraceConstants.BACKGROUND_OPTION, TraceConstants._90);			
			PreferenceConverter.setValue(store, TraceConstants.BACKGROUND_RGB, fBackgroundColorEditor.getColorValue());			
		}
		
		if(!fClassDefaultRadioButton.getSelection())
		{
			store.setValue(TraceConstants.CLASSES_OPTION, TraceConstants.CLASS_ONE_COLOR);
			PreferenceConverter.setValue(store, TraceConstants.CLASSES_RGB, fClassColorEditor.getColorValue());			
			
		}
		else
		{
			store.setValue(TraceConstants.CLASSES_OPTION, TraceConstants.CLASS_DEFAULT_COLOR);			
		}
							
		PreferenceConverter.setValue(store, TraceConstants.SELECTION_RGB, fSelectionColorEditor.getColorValue());
		PreferenceConverter.setValue(store, TraceConstants.UNKNOWN_RGB, fUnknownColorEditor.getColorValue());

        
        SpectrumColorMap.updateColors();
        TraceUIPlugin.getDefault().savePluginPreferences();
		return true;
	}
	
	/**
	 * Returns the font data that describes the font to use for views
	 */
	public static FontData getConsoleFontData() { 
		IPreferenceStore pstore= TraceUIPlugin.getDefault().getPreferenceStore();
		return PreferenceConverter.getFontData(pstore, TraceConstants._96);
	}

}
