/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IColumnExtension.java,v 1.1 2005/07/22 14:49:36 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;
import org.eclipse.jface.viewers.*;
import org.eclipse.core.runtime.*;

/**
 * This is an interface to be implemented by any extension of 
 * extension point org.eclipse.hyades.trace.views.columnExtension
 * <p>
 * org.eclipse.hyades.trace.views.columnExtension enables implmenter to contribute
 * columns in TPTP statistics views. ie. Execution Time Statistics, Memory Statistics,
 * and Method Coverage statistics.
 * <p>
 * <b>Note:</b> This class is going to be deprecated and replaced with an external class in TPTP 4.1.
 * 
 * @see org.eclipse.jface.viewers.ITableLabelProvider
 * @see org.eclipse.core.runtime.IExecutableExtension
 * 
 */
public interface IColumnExtension extends ITableLabelProvider,IExecutableExtension {
	
	/**
	 * Compares two cells of a given column
	 * @param pos column number
	 * @param e1 first cell content link
	 * @param e2 second cell content link
	 * @return the result of the comparison
	 */
	public int compare(int pos, Object e1, Object e2);

}
