/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MethodCallDetails.java,v 1.1 2005/07/22 14:49:36 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.models.trace.TRCMethod;

public class MethodCallDetails {
	
	protected TRCMethod method;
	protected int calls;

	/**
	 * @param method
	 * @param calls
	 */
	public MethodCallDetails(TRCMethod method, int calls) {
		super();
		this.method = method;
		this.calls = calls;
	}
	/**
	 * @return Returns the calls.
	 */
	public int getCalls() {
		return calls;
	}
	/**
	 * @param calls The calls to set.
	 */
	public void setCalls(int calls) {
		this.calls = calls;
	}
	/**
	 * @return Returns the method.
	 */
	public TRCMethod getMethod() {
		return method;
	}
	/**
	 * @param method The method to set.
	 */
	public void setMethod(TRCMethod method) {
		this.method = method;
	}
}
