/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenSource.java,v 1.11 2005/09/14 15:32:27 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.provisional.context.ContextOpenSourceHandlerManager;
import org.eclipse.hyades.ui.provisional.context.IContextOpenSourceProvider;
import org.eclipse.jface.dialogs.MessageDialog;


public class OpenSource
{
/**
 * openSource is takes an object of either a JMessage, JObject or JClass and attempts
 * to locate the source for the definition of that object within the workbench.  If the
 * source is found, the text editor within the Java Perspective is opened and the source 
 * is highlighted.
 * @param Object selection - the object for which you want the source definition.
 */	
public static void openSource(Object selection) {	

	IContextOpenSourceProvider contextOpenSourceProvider = null;
	
	if (selection != null && selection instanceof EObject) {
		String context = ContextUpdaterHelper.getContext((EObject)selection);	
	
		contextOpenSourceProvider = ContextOpenSourceHandlerManager.getContextOpenSourceProvider(context);
		
		if (contextOpenSourceProvider!=null && !contextOpenSourceProvider.openSource(context,(EObject)selection)) {
			MessageDialog.openInformation(
					UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(),
					TraceMessages.TRC_MSGT,
					TraceUIMessages._69);	
		}
		else if (contextOpenSourceProvider == null)
		{
			MessageDialog.openInformation(
					UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(),
					TraceMessages.TRC_MSGT,
					TraceUIMessages._227);	
		}
	}
}


}