/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SortByColumnDialog.java,v 1.6 2009/08/11 21:15:30 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/**
 * Dialog for specifying column of view to sort
 */
public class SortByColumnDialog extends Dialog {

	private String 		_title;
	private Table 		_list;
	private Button 		_ascButton;
	private Button 		_descButton;
	
	private List 	_columns;
	private int _sortSequence = -1;
	private StatisticTableColumnInfo _sortColumn = null;
	
	/**
	 * SortByColumnDialog constructor comment.
	 * 
	 * @param windowTitle
	 *            java.lang.String
	 * @param windowImage
	 *            org.eclipse.swt.graphics.Image
	 */
	
	public SortByColumnDialog(Shell shell, String windowTitle, Image windowImage, List columns, int sortSequence) {
		super(shell);
		_title = windowTitle;
	
		setDefaultImage(windowImage);

		_columns = new ArrayList(columns.size());
		_columns.addAll(columns);
		
		_sortSequence = sortSequence;
	}
	/**
	 * Configures the given shell in prepartaion for opening this window
	 * in it.
	 * <p>
	 * The default implementation of this framework method
	 * sets the shell's image and gives it a grid layout. 
	 * Subclasses may extend or reimplement.
	 * </p>
	 * 
	 * @param newShell the shell
	 */
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}
	
	/**
	 * Creates and returns the contents of the upper part 
	 * of the dialog (above the button bar).
	 *
	 * Subclasses should overide.
	 *
	 * @param the parent composite to contain the dialog area
	 * @return the dialog area control
	 */
	protected Control createDialogArea(Composite parent) {
		Composite result = (Composite) super.createDialogArea(parent);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 3;
		layout.verticalSpacing = 15;
		result.setLayout(layout);
		result.setLayoutData(GridUtil.createFill());

		Label description = new Label(result, SWT.NONE);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 3;
		description.setLayoutData(data);

		description.setText(TraceUIMessages._59);

		Composite dataComp = new Composite(result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		dataComp.setLayout(layout);
		data = GridUtil.createFill();
		data.horizontalSpan = 3;
		dataComp.setLayoutData(data);

		_list = new Table(dataComp, SWT.BORDER | SWT.RADIO | SWT.H_SCROLL);
		data = GridUtil.createFill();
		_list.setLayoutData(data);

		Composite buttonWidget = new Composite(dataComp, SWT.NULL);
		data = new GridData();
		data.grabExcessVerticalSpace = true;
		data.verticalAlignment = GridData.FILL;
		buttonWidget.setLayoutData(data);
		GridLayout blayout = new GridLayout();
		blayout.numColumns = 2;
		buttonWidget.setLayout(blayout);

		_ascButton = new Button(buttonWidget, SWT.RADIO);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_ascButton.setLayoutData(data);
		_ascButton.setText(TraceUIMessages._60);

		_descButton = new Button(buttonWidget, SWT.RADIO);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_descButton.setLayoutData(data);
		_descButton.setText(TraceUIMessages._61);

		_ascButton.setEnabled(true);
		_descButton.setEnabled(true);

		populateList();

		return result;
	}
	
	public StatisticTableColumnInfo sortColumn()
	{
		return _sortColumn;
	}

	public int sortSequence()
	{
		return _sortSequence;
	}

	/**
	 * Notifies that the ok button of this dialog has been pressed.
	 * <p>
	 * The default implementation of this framework method sets
	 * this dialog's return code to <code>Window.OK</code>
	 * and closes the dialog. Subclasses may override.
	 * </p>
	 */
	protected void okPressed() {
		_sortColumn = (StatisticTableColumnInfo)_list.getSelection()[0].getData();
		
		if (_ascButton.getSelection())
			_sortSequence = 1;
		else
			_sortSequence = -1;
		
		super.okPressed();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/7/2001 3:05:18 PM)
	 */
	private void populateList() {
		_list.removeAll();
		
		for (int idx = 0; idx < _columns.size(); idx++) {
			StatisticTableColumnInfo ci = (StatisticTableColumnInfo) _columns.get(idx);

			if (ci.getColumnData().visibleChooseColumns())
			{
	 			TableItem item = new TableItem(_list, SWT.NONE);
				item.setData(ci);
				
				if (ci.isDeltaColumn())
					item.setText((new StringBuffer(TraceUIMessages._85)).append(" : ")
							.append(ci.getColumnData().name()).toString());
				else
					item.setText(ci.getColumnData().name());
				
				if (ci.isSortColumn())
					_list.setSelection(new TableItem[] {item});
			}
		}
			
		if (_list.getSelectionIndex() < 0)
			_list.select(0);
		
		_ascButton.setSelection(sortSequence() >  0);
		_descButton.setSelection(sortSequence() <  0);
	}
}
