/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StatisticTableColumnInfo.java,v 1.8 2010/06/30 20:45:51 jwest Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.TreeColumn;

public class StatisticTableColumnInfo {

	private boolean _isSortColumn = false;
	private boolean _isDeltaColumn = false;	
	private ColumnData _columnData;
	
	public ColumnData getColumnData() {
		return _columnData;
	}
	
	public boolean isSortColumn() {
		return _isSortColumn;
	}

	public boolean isDeltaColumn() {
		return _isDeltaColumn;
	}

	public void setSortColumn(boolean flag) {
		_isSortColumn = flag;
	}

	public void setDeltaColumn(boolean flag) {
		_isDeltaColumn = flag;
	}

	static public StatisticTableColumnInfo getStatisticTableColumnInfo(TreeColumn col) {
		if (col.getData() != null && col.getData() instanceof StatisticTableColumnInfo) {
			return (StatisticTableColumnInfo)(col.getData());
		}
		else {
			return null;
		}
	}


	private StatisticTableColumnInfo(StatisticView statisticView, ColumnData data) {
		TreeColumn treeColumn = new TreeColumn(statisticView.getTree(), SWT.NULL | SWT.NO_BACKGROUND | data.getAlignment());
		treeColumn.setData(this);
		initializeTreeColumn(statisticView, treeColumn, data, true);
		
		//bug 80440, 224979 
		TreeViewerColumn tvc = new TreeViewerColumn((TreeViewer)(statisticView.getTreeViewer()),treeColumn);
		CellLabelProvider clp = statisticView.getCellLabelProvider(data);
		if (clp!=null) {
			tvc.setLabelProvider(clp);
		}
		//end bug 80440, 224979
	}

	public StatisticTableColumnInfo(StatisticView statisticView, ColumnData data, boolean deltaColumnsEnabled) {
		TreeColumn treeColumn = new TreeColumn(statisticView.getTree(), SWT.NULL | SWT.NO_BACKGROUND | data.getAlignment());
		treeColumn.setData(this);
		initializeTreeColumn(statisticView, treeColumn, data, false);
		
		//bug 80440
		TreeViewerColumn tvc = new TreeViewerColumn((TreeViewer)(statisticView.getTreeViewer()),treeColumn);
		CellLabelProvider clp = statisticView.getCellLabelProvider(data);
		if (clp!=null) {
			tvc.setLabelProvider(clp);
		}
		//end bug 80440
						
		if (deltaColumnsEnabled && data.supportsDelta()) {
			new StatisticTableColumnInfo(statisticView, data);
		}
		
	}
	
	private void initializeTreeColumn(StatisticView statisticView, TreeColumn treeColumn, ColumnData data, boolean isDeltaColumn) {
		_columnData = data;
		_isDeltaColumn = isDeltaColumn;
		
		treeColumn.setResizable(data.isResizable());
		if (isDeltaColumn) {
			treeColumn.setText((new StringBuffer(TraceUIMessages._85))
					.append(" : ").append(data.name()).toString());
		}
		else {
			treeColumn.setText(data.name());
		}
		
		treeColumn.setWidth(data.width());

		treeColumn.addSelectionListener(statisticView.getSelectionListener());
		treeColumn.addControlListener(statisticView);
	}
}