/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceSDUtil.java,v 1.1 2005/07/22 14:49:39 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;

import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/**
 * The util class to be used in the desktop.
 */

public class TraceSDUtil {

	// Id of the Trace Interactions view -> also in plugin.xml: please keep in sync
	public static final String UML2SD_TRACE_VIEW_ID =
		"org.eclipse.hyades.uml2sd.trace.view.TraceSDView"; //$NON-NLS-1$

	public static void shutdown() throws Exception {
		if (images != null) {
			for (Iterator e = images.values().iterator(); e.hasNext();) {
				Object next = e.next();
				if (next instanceof Image && !((Image) next).isDisposed()) {
					((Image) next).dispose();
				}
			}
			images.clear();
			images = null;
		}
		debugUml2SDTracePlugin("stop finished"); //$NON-NLS-1$
	}
	
	private static URL BASIC_URL = null;
	private static Hashtable images = null;
	/**
	 * Load image with that _name and return it
	 */
	public static Image getResourceImage( String _name )
	{
		if ( TraceUIPlugin.getDefault()== null) {
			return null;
		}
		if (images != null) {
			Image img = (Image)images.get(_name);
			if (img != null &&
				!img.isDisposed()) {
				debugUml2SDTracePlugin("Optimizing for image "+_name); //$NON-NLS-1$
				return img;
			}
		} else {
			images = new Hashtable();
		}
		ImageDescriptor imgd = getResourceImageDescriptor(_name);
		if (imgd == null) {
			return null;
		}
		Image img = imgd.createImage();
		images.put(_name, img);
		return img;
	}
	
	/**
	 * @param _name
	 * @return
	 */
	public static ImageDescriptor getResourceImageDescriptor(String _name) {
		if (BASIC_URL == null) {
			try {
				BASIC_URL = new URL( "platform", "localhost", "plugin"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			} catch (MalformedURLException e) {
				e.printStackTrace();
				return null;
			}
		}
		ImageDescriptor imgd;
		try {
			URL url = new URL( BASIC_URL, "plugin/org.eclipse.hyades.trace.views/icons/"+_name);  //$NON-NLS-1$
			imgd = ImageDescriptor.createFromURL(url);
			debugUml2SDTracePlugin("Getting image "+url); //$NON-NLS-1$
		} catch (MalformedURLException e) {
			imgd = ImageDescriptor.getMissingImageDescriptor();
			debugUml2SDTracePlugin("Missing image "+BASIC_URL+_name); //$NON-NLS-1$
		}
		return imgd;
	}

	/**
	 * Log system of the plugin
	 */
	public static boolean debugMatch  = checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/match"); //$NON-NLS-1$
	public static boolean debugLoader = checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/loader"); //$NON-NLS-1$
	public static boolean debugEvents = checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/events"); //$NON-NLS-1$
	public static boolean debugPlugin = checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/plugin"); //$NON-NLS-1$
	
	/**
	 * @param option
	 * @return
	 */
	private static boolean checkForDebugTrace(String option) {
		String value = Platform.getDebugOption(option);
		if (value != null && value.equalsIgnoreCase("true")) { //$NON-NLS-1$
			return true;
		}
		return false;
	}
	/**
	 * @param msg
	 */
	public static void debugUml2SDTraceMatch(String msg) {
		if (debugMatch) {
			System.out.println(msg);
		}
	}

	/**
	 * @param msg
	 */
	public static void debugUml2SDTraceLoader(String msg) {
		if (debugLoader) {
			System.out.println(msg);
		}
	}

	/**
	 * @param msg
	 */
	public static void debugUml2SDTraceEvents(String msg) {
		if (debugEvents) {
			System.out.println(msg);
		}
	}

	/**
	 * @param msg
	 */
	public static void debugUml2SDTracePlugin(String msg) {
		if (debugPlugin) {
			System.out.println(msg);
		}
	}

}
